/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.client;

import com.havnnek.style_combat.client.PlayerStyleData;
import com.havnnek.style_combat.network.NetworkHandler;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class StyleScoringManager {
    private static final Map<UUID, PlayerStyleData> serverData = new ConcurrentHashMap<UUID, PlayerStyleData>();
    private static PlayerStyleData clientData = null;

    public static PlayerStyleData get(Player player) {
        if (player == null) {
            return null;
        }
        if (player.m_9236_().f_46443_) {
            return clientData;
        }
        return serverData.computeIfAbsent(player.m_20148_(), k -> new PlayerStyleData());
    }

    public static void sync(ServerPlayer player) {
        if (player == null) {
            return;
        }
        NetworkHandler.sync(player);
    }

    public static void syncIfServer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StyleScoringManager.sync(sp);
        }
    }

    public static void addKillStyle(Player player, int points) {
        if (player == null) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            if (clientData != null) {
                clientData.addPoints(points);
            }
            return;
        }
        PlayerStyleData d = StyleScoringManager.get(player);
        if (d == null) {
            return;
        }
        d.addPoints(points);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StyleScoringManager.sync(sp);
        }
    }

    public static void addComboHit(Player player, int basePoints) {
        if (player == null) {
            return;
        }
        if (player.m_9236_().f_46443_) {
            if (clientData != null) {
                clientData.addComboHit(basePoints);
            }
            return;
        }
        PlayerStyleData d = StyleScoringManager.get(player);
        if (d == null) {
            return;
        }
        d.addComboHit(basePoints);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            StyleScoringManager.sync(sp);
        }
    }

    public static void applyClientSync(int stylePoints, int combo, String rank) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            PlayerStyleData d = clientData;
            if (d == null) {
                clientData = d = new PlayerStyleData();
            }
            d.setStylePoints(stylePoints);
            try {
                Field f = PlayerStyleData.class.getDeclaredField("comboCount");
                f.setAccessible(true);
                f.setInt(d, combo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void tickAll() {
        for (Map.Entry<UUID, PlayerStyleData> e : serverData.entrySet()) {
            PlayerStyleData d = e.getValue();
            d.decay();
        }
    }

    public static PlayerStyleData getClientData() {
        return clientData;
    }

    public static void setClientLocalData(PlayerStyleData data) {
        clientData = data;
    }

    public static void initClientLocal() {
        if (clientData == null) {
            clientData = new PlayerStyleData();
        }
    }
}

