/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.client;

import com.havnnek.style_combat.config.StyleCombatConfig;

public class PlayerStyleData {
    private int stylePoints = 0;
    private long lastActionTime = System.currentTimeMillis();
    private int comboCount = 0;
    private long lastHitTime = 0L;
    private String forcedRank = null;
    private int hitTakenCount = 0;
    private long lastHitTakenTime = 0L;

    public void addPoints(int points) {
        this.stylePoints += points;
        if (this.stylePoints > (Integer)StyleCombatConfig.MAX_POINTS.get()) {
            this.stylePoints = (Integer)StyleCombatConfig.MAX_POINTS.get();
        }
        this.lastActionTime = System.currentTimeMillis();
    }

    public void addComboHit(int basePoints) {
        long now = System.currentTimeMillis();
        this.comboCount = now - this.lastHitTime < (long)((Integer)StyleCombatConfig.COMBO_IN_TIME.get()).intValue() ? ++this.comboCount : 1;
        this.lastHitTime = now;
        int rawBonus = this.comboCount * (Integer)StyleCombatConfig.BONUS_POINTS_IN_COMBO.get();
        int cappedBonus = Math.min(rawBonus, (Integer)StyleCombatConfig.MAX_BONUS_POINTS_IN_COMBO.get());
        int totalPoints = basePoints + cappedBonus;
        this.addPoints(totalPoints);
    }

    public void resetCombo() {
        this.comboCount = 0;
    }

    public void setStylePoints(int points) {
        this.stylePoints = Math.max(0, points);
        this.lastActionTime = System.currentTimeMillis();
    }

    public void setComboCount(int c) {
        this.comboCount = Math.max(0, c);
    }

    public void setRank(String rank) {
        this.forcedRank = rank;
    }

    public void decay() {
        long now = System.currentTimeMillis();
        if (now - this.lastActionTime > (long)((Integer)StyleCombatConfig.TIME_DECREASE_POINTS.get()).intValue() && this.stylePoints > 0) {
            String currentRank = this.computeRank();
            this.stylePoints = currentRank.equals("S") || currentRank.equals("SS") || currentRank.equals("SSS") ? (this.stylePoints -= ((Integer)StyleCombatConfig.HIGH_RANK_DECAY_POINTS.get()).intValue()) : (this.stylePoints -= ((Integer)StyleCombatConfig.POINTS_DECREASE_EACH_MILIS.get()).intValue());
            if (this.stylePoints < 0) {
                this.stylePoints = 0;
            }
            this.lastActionTime = now;
        }
        if (now - this.lastHitTime > (long)((Integer)StyleCombatConfig.COMBO_TIME_RESET.get()).intValue()) {
            this.resetCombo();
        }
    }

    public void onPlayerHit() {
        long now = System.currentTimeMillis();
        this.hitTakenCount = now - this.lastHitTakenTime < (long)((Integer)StyleCombatConfig.HIT_TAKEN_COMBO_TIME.get()).intValue() ? ++this.hitTakenCount : 1;
        this.lastHitTakenTime = now;
        int penalty = (Integer)StyleCombatConfig.HIT_TAKEN_BASE_PENALTY.get() + (this.hitTakenCount - 1) * (Integer)StyleCombatConfig.HIT_TAKEN_STACK_PENALTY.get();
        this.stylePoints = Math.max(0, this.stylePoints - penalty);
        this.resetCombo();
    }

    public void resetHitTaken() {
        this.hitTakenCount = 0;
    }

    public int getHitTakenCount() {
        return this.hitTakenCount;
    }

    public int getStylePoints() {
        return this.stylePoints;
    }

    public int getComboCount() {
        return this.comboCount;
    }

    public String getRank() {
        if (this.forcedRank != null) {
            return this.forcedRank;
        }
        return this.computeRank();
    }

    private String computeRank() {
        int p = this.stylePoints;
        if (p >= (Integer)StyleCombatConfig.RANK_SSS_THRESHOLD.get()) {
            return "SSS";
        }
        if (p >= (Integer)StyleCombatConfig.RANK_SS_THRESHOLD.get()) {
            return "SS";
        }
        if (p >= (Integer)StyleCombatConfig.RANK_S_THRESHOLD.get()) {
            return "S";
        }
        if (p >= (Integer)StyleCombatConfig.RANK_A_THRESHOLD.get()) {
            return "A";
        }
        if (p >= (Integer)StyleCombatConfig.RANK_B_THRESHOLD.get()) {
            return "B";
        }
        if (p >= (Integer)StyleCombatConfig.RANK_C_THRESHOLD.get()) {
            return "C";
        }
        return "D";
    }

    public int getPointsInCurrentRank() {
        int p = this.stylePoints;
        if (p < (Integer)StyleCombatConfig.RANK_C_THRESHOLD.get()) {
            return p;
        }
        if (p < (Integer)StyleCombatConfig.RANK_B_THRESHOLD.get()) {
            return p - (Integer)StyleCombatConfig.RANK_C_THRESHOLD.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_A_THRESHOLD.get()) {
            return p - (Integer)StyleCombatConfig.RANK_B_THRESHOLD.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_S_THRESHOLD.get()) {
            return p - (Integer)StyleCombatConfig.RANK_A_THRESHOLD.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_SS_THRESHOLD.get()) {
            return p - (Integer)StyleCombatConfig.RANK_S_THRESHOLD.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_SSS_THRESHOLD.get()) {
            return p - (Integer)StyleCombatConfig.RANK_SS_THRESHOLD.get();
        }
        return (Integer)StyleCombatConfig.MAX_POINTS.get() - (Integer)StyleCombatConfig.RANK_SSS_THRESHOLD.get();
    }

    public int getPointsForNextRank() {
        int p = this.stylePoints;
        if (p < (Integer)StyleCombatConfig.RANK_C_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.RANK_C_THRESHOLD.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_B_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.POINTS_NEXT_C.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_A_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.POINTS_NEXT_B.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_S_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.POINTS_NEXT_A.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_SS_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.POINTS_NEXT_S.get();
        }
        if (p < (Integer)StyleCombatConfig.RANK_SSS_THRESHOLD.get()) {
            return (Integer)StyleCombatConfig.POINTS_NEXT_SS.get();
        }
        return (Integer)StyleCombatConfig.POINTS_NEXT_SSS.get();
    }
}

