/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.api.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.havnnek.style_combat.api.datapack.DataPackDrivenRuleManager;
import com.havnnek.style_combat.api.datapack.RuleEntry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataPackDrivenRuleReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final DataPackDrivenRuleReloadListener INSTANCE = new DataPackDrivenRuleReloadListener();
    private final Map<ResourceLocation, RuleEntry> rules = new HashMap<ResourceLocation, RuleEntry>();

    public DataPackDrivenRuleReloadListener() {
        super(GSON, "style_compat");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager manager, ProfilerFiller profiler) {
        this.rules.clear();
        DataPackDrivenRuleManager.get().clearRegisteredAnimations();
        for (Map.Entry<ResourceLocation, JsonElement> entry : jsonMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            JsonObject json = entry.getValue().getAsJsonObject();
            try {
                String trigger;
                String anim = json.get("animation").getAsString();
                int points = json.has("points") ? json.get("points").getAsInt() : 0;
                String actionText = json.has("action_text") ? json.get("action_text").getAsString() : "";
                String colorHex = json.has("color") ? json.get("color").getAsString() : "#FFFFFF";
                int color = this.parseColor(colorHex);
                String mode = json.has("mode") ? json.get("mode").getAsString().toLowerCase(Locale.ROOT) : "add";
                String string = trigger = json.has("trigger") ? json.get("trigger").getAsString().toLowerCase(Locale.ROOT) : "animation";
                if (!(mode.equals("add") || mode.equals("override") || mode.equals("subtract"))) {
                    System.err.println("[StyleCombat] Invalid mode '" + mode + "' in " + String.valueOf(id) + ", defaulting to 'add'");
                    mode = "add";
                }
                if (!(trigger.equals("animation") || trigger.equals("on_kill") || trigger.equals("on_damage"))) {
                    System.err.println("[StyleCombat] Invalid trigger '" + trigger + "' in " + String.valueOf(id) + ", defaulting to 'animation'");
                    trigger = "animation";
                }
                RuleEntry rule = new RuleEntry(anim, trigger, points, actionText, color, mode);
                this.rules.put(id, rule);
                DataPackDrivenRuleManager.get().registerAnimation(anim);
            }
            catch (Exception e) {
                System.err.println("[StyleCombat] Error reading datapack rule: " + String.valueOf(id) + " -> " + e.getMessage());
            }
        }
        System.out.println("[StyleCombat] Loaded " + this.rules.size() + " datapack-driven rules!");
    }

    public RuleEntry getRule(String animId) {
        for (RuleEntry entry : this.rules.values()) {
            if (!entry.animation().equalsIgnoreCase(animId)) continue;
            return entry;
        }
        return null;
    }

    private int parseColor(String hex) {
        try {
            if (((String)hex).startsWith("#")) {
                hex = ((String)hex).substring(1);
            }
            if (((String)hex).length() == 6) {
                hex = "FF" + (String)hex;
            }
            return (int)Long.parseLong((String)hex, 16);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

