/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.style_combat.api.datapack;

import com.havnnek.style_combat.api.datapack.DataPackDrivenRuleReloadListener;
import com.havnnek.style_combat.api.datapack.RuleEntry;
import com.havnnek.style_combat.client.PlayerStyleData;
import com.havnnek.style_combat.client.StyleScoringManager;
import com.havnnek.style_combat.client.renderer.ClientOverlayRenderer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.StaticAnimation;

public class DataPackDrivenRuleManager {
    private static final DataPackDrivenRuleManager INSTANCE = new DataPackDrivenRuleManager();
    private final Set<String> registeredAnimations = new HashSet<String>();
    private final Map<UUID, StaticAnimation> activeAnimations = new HashMap<UUID, StaticAnimation>();

    public static DataPackDrivenRuleManager get() {
        return INSTANCE;
    }

    public void onAnimationPlay(Player player, ResourceLocation animId) {
        if (player == null || animId == null) {
            return;
        }
        String animKey = animId.toString();
        RuleEntry rule = DataPackDrivenRuleReloadListener.INSTANCE.getRule(animKey);
        if (rule == null) {
            return;
        }
        if (!"animation".equals(rule.trigger())) {
            return;
        }
        this.applyRule(player, rule);
    }

    public void onKillTrigger(Player player) {
        if (player == null) {
            return;
        }
        StaticAnimation anim = this.getActiveAnimation(player);
        if (anim == null) {
            return;
        }
        String animKey = anim.getRegistryName().toString();
        RuleEntry rule = DataPackDrivenRuleReloadListener.INSTANCE.getRule(animKey);
        if (rule != null && "on_kill".equals(rule.trigger())) {
            this.applyRule(player, rule);
        }
    }

    public void onDamageTrigger(Player player) {
        if (player == null) {
            return;
        }
        StaticAnimation anim = this.getActiveAnimation(player);
        if (anim == null) {
            return;
        }
        String animKey = anim.getRegistryName().toString();
        RuleEntry rule = DataPackDrivenRuleReloadListener.INSTANCE.getRule(animKey);
        if (rule != null && "on_damage".equals(rule.trigger())) {
            this.applyRule(player, rule);
        }
    }

    private void applyRule(Player player, RuleEntry rule) {
        if (rule == null) {
            return;
        }
        if (rule.mode().equalsIgnoreCase("override")) {
            StyleScoringManager.get(player).setStylePoints(0);
        } else if (rule.mode().equalsIgnoreCase("subtract")) {
            PlayerStyleData data = StyleScoringManager.get(player);
            int newPoints = data.getStylePoints() - rule.points();
            if (newPoints < 0) {
                newPoints = 0;
            }
            data.setStylePoints(newPoints);
            if (rule.actionText() != null && !rule.actionText().isEmpty()) {
                ClientOverlayRenderer.addActionText(rule.actionText(), rule.color());
            }
            return;
        }
        StyleScoringManager.addKillStyle(player, rule.points());
        ClientOverlayRenderer.addActionText(rule.actionText(), rule.color());
    }

    public void setActiveAnimation(Player player, StaticAnimation anim) {
        if (player == null || anim == null) {
            return;
        }
        this.activeAnimations.put(player.m_20148_(), anim);
    }

    public void clearActiveAnimation(Player player) {
        if (player == null) {
            return;
        }
        this.activeAnimations.remove(player.m_20148_());
    }

    public StaticAnimation getActiveAnimation(Player player) {
        return this.activeAnimations.get(player.m_20148_());
    }

    public void registerAnimation(String animPath) {
        this.registeredAnimations.add(animPath);
    }

    public void clearRegisteredAnimations() {
        this.registeredAnimations.clear();
    }
}

