/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.data;

import com.mafuyu404.oelib.data.DataManagerBridge;
import com.mafuyu404.oelib.data.DataRegistry;
import com.mafuyu404.oelib.data.mvel.ExpressionEngine;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.data.DataPackFunctions;
import com.mafuyu404.smartkeyprompts.data.KeyPromptData;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class KeyPromptEngine {
    private static volatile Map<ResourceLocation, KeyPromptData> cachedData = Map.of();

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.getDataClass() == KeyPromptData.class) {
            SmartKeyPrompts.LOGGER.info("KeyPrompt data reloaded: {} entries loaded, {} invalid", (Object)event.getLoadedCount(), (Object)event.getInvalidCount());
            cachedData = DataManagerBridge.getAllData(KeyPromptData.class);
            DataRegistry.resetExpressionEngine();
            DataRegistry.initializeExpressionEngine();
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!DataRegistry.isExpressionEngineInitialized()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91080_ != null) {
            return;
        }
        DataPackFunctions.setCurrentPlayer((Player)player);
        for (Map.Entry<ResourceLocation, KeyPromptData> entry : cachedData.entrySet()) {
            KeyPromptData data = entry.getValue();
            if (!ExpressionEngine.checkModLoadedCondition(data.vars())) continue;
            KeyPromptEngine.processKeyPromptData(data, (Player)player);
        }
    }

    private static void processKeyPromptData(KeyPromptData data, Player player) {
        Map context = ExpressionEngine.createContext(data.vars());
        for (KeyPromptData.Entry entry : data.entries()) {
            if (!ExpressionEngine.checkConditions(entry.when(), (Map)context)) continue;
            ExpressionEngine.executeActions(entry.then(), (Map)context);
        }
    }
}

