/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.smartkeyprompts.compat;

import com.mafuyu404.smartkeyprompts.SmartKeyPrompts;
import com.mafuyu404.smartkeyprompts.util.KeyUtils;
import com.mafuyu404.smartkeyprompts.util.PlayerUtils;
import com.mafuyu404.smartkeyprompts.util.PromptUtils;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="smartkeyprompts", value={Dist.CLIENT})
public class SlashBlade {
    private static final String modid = "slashblade_skp";
    private static String lastSlashArt = "";

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!ModList.get().isLoaded("slashblade")) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            ItemStack mainHandItem = player.m_21205_();
            if (mainHandItem.m_41720_() instanceof ItemSlashBlade) {
                SlashBlade.showBasicKeys(mainHandItem);
                if (SlashBlade.isBladeUnavailable(mainHandItem)) {
                    if (!lastSlashArt.isEmpty()) {
                        lastSlashArt = "";
                    }
                    return;
                }
                SlashBlade.showSlashArtKeys(mainHandItem);
                SlashBlade.canUseSummonedSwordKeys(mainHandItem);
            } else if (!lastSlashArt.isEmpty()) {
                lastSlashArt = "";
            }
        }
    }

    private static void showBasicKeys(ItemStack itemStack) {
        String keyShift = KeyUtils.getKeyByDesc("key.sneak");
        String keyForward = KeyUtils.getKeyByDesc("key.forward");
        String keyBack = KeyUtils.getKeyByDesc("key.back");
        String keyUse = KeyUtils.getKeyByDesc("key.use");
        String keyV = KeyUtils.getKeyByDesc("key.slashblade.special_move");
        PromptUtils.addDesc("key.slashblade.guard").forKey(keyShift).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeyDisplayName("key.sneak")).toGroup(modid);
        if (PlayerUtils.hasTargetedEntityIsMob()) {
            PromptUtils.addDesc("key.slashblade.air_trick").forKey(keyShift + "+" + keyForward + "+" + keyV).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.forward", "key.slashblade.special_move")).toGroup(modid);
        } else {
            PromptUtils.addDesc("key.slashblade.trick_up").forKey(keyShift + "+" + keyForward + "+" + keyV).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.forward", "key.slashblade.special_move")).toGroup(modid);
        }
        if (PlayerUtils.isPlayerMoving()) {
            PromptUtils.addDesc("key.slashblade.trick_dodge").forKey(keyV).toGroup(modid);
        }
        if (PlayerUtils.isPlayerInAir()) {
            PromptUtils.addDesc("key.slashblade.trick_down").forKey(keyShift + "+" + keyBack + "+" + keyV).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back", "key.slashblade.special_move")).toGroup(modid);
            PromptUtils.addDesc("key.slashblade.aerial_cleave").forKey(keyShift + "+" + keyBack + "+" + keyUse).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back", "key.use")).toGroup(modid);
        } else if (PlayerUtils.isPlayerOnGround()) {
            PromptUtils.addDesc("key.slashblade.upperslash").forKey(keyShift + "+" + keyBack + "+" + keyUse).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back", "key.use")).toGroup(modid);
            PromptUtils.addDesc("key.slashblade.rapid_slash").forKey(keyShift + "+" + keyForward + "+" + keyUse).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.forward", "key.use")).toGroup(modid);
            PromptUtils.addDesc("key.slashblade.upperslash_jump").forKey(keyShift + "+" + keyBack + "+" + keyUse).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back") + "+\u957f\u6309" + (KeyUtils.isRightClickKey("key.use") ? "\u53f3\u952e" : KeyUtils.getKeyDisplayName("key.use"))).toGroup(modid);
        }
    }

    private static void showSlashArtKeys(ItemStack itemStack) {
        ResourceLocation slashArtKey = SlashBlade.getSlashArtKey(itemStack);
        if (slashArtKey != null && !SlashBlade.isDefaultOrNoneSA(slashArtKey)) {
            String slashArtString = slashArtKey.toString();
            if (!slashArtString.equals(lastSlashArt)) {
                SlashBlade.showSlashArtKey(slashArtKey);
                lastSlashArt = slashArtString;
            } else {
                SlashBlade.showSlashArtKey(slashArtKey);
            }
        } else {
            lastSlashArt = "";
        }
    }

    private static void canUseSummonedSwordKeys(ItemStack itemStack) {
        if (!SlashBlade.canUseSummonedSword(itemStack)) {
            return;
        }
        String keyShift = KeyUtils.getKeyByDesc("key.sneak");
        String keyForward = KeyUtils.getKeyByDesc("key.forward");
        String keyBack = KeyUtils.getKeyByDesc("key.back");
        String keyMiddle = KeyUtils.getKeyByDesc("key.slashblade.summon_blade");
        int proudSoul = SlashBlade.getProudSoul(itemStack);
        if (proudSoul >= 2) {
            PromptUtils.addDesc("key.slashblade.summonedswords").forKey(keyMiddle).toGroup(modid);
            if (proudSoul >= 20) {
                PromptUtils.addDesc("key.slashblade.spiral_swords").forKey(keyMiddle).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeyDisplayName("key.slashblade.summon_blade")).toGroup(modid);
                PromptUtils.addDesc("key.slashblade.storm_swords").forKey(keyShift + "+" + keyBack + "+" + keyMiddle).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back", "key.slashblade.summon_blade")).toGroup(modid);
                PromptUtils.addDesc("key.slashblade.blistering_swords").forKey(keyShift + "+" + keyForward + "+" + keyMiddle).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.forward", "key.slashblade.summon_blade")).toGroup(modid);
                PromptUtils.addDesc("key.slashblade.heavy_rain_swords").forKey(keyShift + "+" + keyBack + "+" + keyForward + "+" + keyMiddle).withKeyAlias("\u6309\u4f4f" + KeyUtils.getKeysDisplayName("key.sneak", "key.back", "key.forward", "key.slashblade.summon_blade")).toGroup(modid);
            }
        }
    }

    private static boolean canUseSummonedSword(ItemStack itemStack) {
        try {
            if (!SwordType.from((ItemStack)itemStack).contains(SwordType.BEWITCHED)) {
                return false;
            }
            int strengthLevel = itemStack.getEnchantmentLevel(Enchantments.f_44988_);
            if (strengthLevel < 1) {
                return false;
            }
            int proudSoul = SlashBlade.getProudSoul(itemStack);
            return proudSoul >= 2;
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SlashBlade] Error checking phantom sword availability: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static int getProudSoul(ItemStack itemStack) {
        try {
            return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getProudSoulCount).orElse(0);
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SlashBlade] Error getting proud soul: {}", (Object)e.getMessage());
            return 0;
        }
    }

    private static boolean isBladeUnavailable(ItemStack itemStack) {
        try {
            if (!SwordType.from((ItemStack)itemStack).contains(SwordType.ENCHANTED)) {
                return true;
            }
            return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.isBroken() || state.isSealed()).orElse(false);
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SlashBlade] Error checking blade state: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean isDefaultOrNoneSA(ResourceLocation slashArtKey) {
        if (slashArtKey == null) {
            return true;
        }
        return SlashArtsRegistry.NONE.getId().equals((Object)slashArtKey);
    }

    private static ResourceLocation getSlashArtKey(ItemStack itemStack) {
        try {
            return itemStack.getCapability(ItemSlashBlade.BLADESTATE).map(ISlashBladeState::getSlashArtsKey).orElse(null);
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SlashBlade] Error getting slash art key from capability: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static void showSlashArtKey(ResourceLocation slashArtKey) {
        try {
            String artName = slashArtKey.m_135815_();
            if ("none".equals(artName)) {
                return;
            }
            SlashBlade.showKeyForArt(artName);
        }
        catch (Exception e) {
            SmartKeyPrompts.LOGGER.error("[SlashBlade] Error showing slash art key for '{}': {}", (Object)slashArtKey, (Object)e.getMessage());
        }
    }

    private static void showKeyForArt(String artName) {
        String keyTranslationKey = "key.slashblade." + artName;
        PromptUtils.addDesc(keyTranslationKey).forKey("key.mouse.right").withKeyAlias("\u957f\u6309" + (KeyUtils.isRightClickKey("key.use") ? "\u53f3\u952e" : KeyUtils.getKeyDisplayName("key.use")) + "\u540e\u677e\u5f00").toGroup(modid);
    }
}

