/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.config.ClientConfig;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;

public abstract class DisplayEntry {
    public static final int ENTRY_HEIGHT = 18;
    private static final int TEXT_ITEM_MARGIN = 4;
    private final Rarity rarity;
    private int remainingTicks;
    private int displayAmount;
    private Component component;

    protected DisplayEntry(int displayAmount, Rarity rarity) {
        this.displayAmount = displayAmount;
        this.rarity = rarity;
        this.resetEntry();
    }

    private static MutableComponent wrapInBrackets(Component toWrap) {
        return Component.m_237113_((String)"(").m_7220_(toWrap).m_130946_(")");
    }

    public int getDisplayAmount() {
        return this.displayAmount;
    }

    public boolean mayDiscard() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract Component getEntryName();

    protected abstract int getInventoryCount(Inventory var1);

    public Component getTextComponent(Player player) {
        if (this.component == null) {
            int displayAmount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.text() ? this.getDisplayAmount() : 0;
            int inventoryCount = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.inventoryCount ? this.getInventoryCount(player.m_150109_()) : 0;
            this.component = Component.m_237119_().m_7220_(this.createTextComponent(this.getEntryName(), displayAmount, inventoryCount, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored())).m_6270_(this.getComponentStyle());
        }
        return this.component;
    }

    private Component createTextComponent(Component name, int displayAmount, int inventoryCount, boolean reverse) {
        ArrayList components = Lists.newArrayList();
        if (inventoryCount > 0) {
            components.add(DisplayEntry.wrapInBrackets((Component)Component.m_237113_((String)String.valueOf(inventoryCount))));
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayItemName) {
            components.add(name);
        }
        if (displayAmount > 1 || displayAmount == 1 && ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displaySingleCount) {
            components.add(Component.m_237113_((String)(reverse ? displayAmount + "x" : "x" + displayAmount)));
        }
        if (reverse) {
            Collections.reverse(components);
        }
        return (Component)components.stream().reduce((component1, component2) -> Component.m_237119_().m_7220_(component1).m_130946_(" ").m_7220_(component2)).orElse(Component.m_237119_());
    }

    private Style getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.ignoreRarity && this.rarity != Rarity.COMMON) {
            return Style.f_131099_.m_131140_(this.rarity.f_43022_);
        }
        return Style.f_131099_.m_131140_(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.moveTime, ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime);
        return 1.0f - Mth.m_14036_((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void resetEntry() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.displayTime;
        this.component = null;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1, boolean var2);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount += other.displayAmount;
        this.resetEntry();
    }

    public int getEntryWidth(Minecraft minecraft) {
        int textWidth = minecraft.f_91062_.m_92852_((FormattedText)this.getTextComponent((Player)minecraft.f_91074_));
        return ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite ? textWidth + (textWidth == 0 ? 0 : 4) + 16 : textWidth;
    }

    public void render(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float alpha, float scale) {
        int fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.position.mirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.drawSprite;
        int textStartX = mirrorPosition || !withSprite ? posX : posX + 16 + 4;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        this.renderBg(minecraft, guiGraphics, posX, posY, alpha);
        int n = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280614_(minecraft.f_91062_, this.getTextComponent((Player)minecraft.f_91074_), textStartX, posY + 4, 0xFFFFFF | fadeTime << 24, false);
            if (withSprite) {
                int textWidth = minecraft.f_91062_.m_92852_((FormattedText)this.getTextComponent((Player)minecraft.f_91074_));
                this.renderSprite(minecraft, guiGraphics, mirrorPosition ? posX + textWidth + (textWidth == 0 ? 0 : 4) : posX, posY, scale, (float)fadeTime / 255.0f);
            }
            RenderSystem.disableBlend();
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void renderBg(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float alpha) {
        switch (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.entryBackground) {
            case CHAT: {
                int backgroundOpacity = (int)((Double)minecraft.f_91066_.m_232104_().m_231551_() * (double)(1.0f - alpha) * 255.0) << 24 & 0xFF000000;
                int endY = posY + 16;
                if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.sprite()) {
                    ++endY;
                }
                guiGraphics.m_280509_(posX - 3, posY, posX + this.getEntryWidth(minecraft) + 5, endY, backgroundOpacity);
                break;
            }
            case TOOLTIP: {
                DisplayEntryRenderHelper.renderTooltipInternal(guiGraphics, posX, posY + 3, this.getEntryWidth(minecraft), 9, (int)((1.0f - alpha) * 255.0f));
            }
        }
    }

    protected abstract void renderSprite(Minecraft var1, GuiGraphics var2, int var3, int var4, float var5, float var6);
}

