/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.recipe;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeContainer;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeMatch;
import dev.xkmc.cuisinedelight.content.recipe.PlateCuisineRecipe;
import dev.xkmc.cuisinedelight.init.registrate.CDMisc;
import dev.xkmc.l2library.serial.recipe.BaseRecipe;
import dev.xkmc.l2library.serial.recipe.BaseRecipeBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;

public class PlateCuisineBuilder
extends BaseRecipeBuilder<PlateCuisineBuilder, PlateCuisineRecipe, BaseCuisineRecipe<?>, CuisineRecipeContainer> {
    private double maxBonus = 0.0;
    private double scoreBonus = 0.0;

    public PlateCuisineBuilder(BaseFoodItem result, double minBonus, double maxBonus) {
        super((BaseRecipe.RecType)CDMisc.PLATE_CUISINE.get());
        ((PlateCuisineRecipe)this.recipe).holderItem = result;
        ((PlateCuisineRecipe)this.recipe).saturationBonus = minBonus;
        this.maxBonus = maxBonus;
    }

    public PlateCuisineBuilder add(Ingredient ingredient, double min, double max, double score, double bonus) {
        ((PlateCuisineRecipe)this.recipe).list.add(new CuisineRecipeMatch(ingredient, min, max, score, bonus));
        this.scoreBonus += bonus;
        return this;
    }

    public PlateCuisineBuilder addAtLeast(Ingredient ingredient, double min, double score, double bonus) {
        return this.add(ingredient, min, 2.0 - min, score, bonus);
    }

    public void save(Consumer<FinishedRecipe> pvd, ResourceLocation id) {
        if (this.scoreBonus > 0.0) {
            ((PlateCuisineRecipe)this.recipe).saturationBonusModifier = this.maxBonus / this.scoreBonus;
        }
        super.save(pvd, id);
    }

    public void save(Consumer<FinishedRecipe> pvd) {
        this.save(pvd, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((PlateCuisineRecipe)this.recipe).holderItem)));
    }
}

