/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.client;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.client.PieRenderer;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookTransformConfig;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.content.logic.IngredientConfig;
import dev.xkmc.cuisinedelight.content.logic.transform.CookTransform;
import dev.xkmc.cuisinedelight.init.data.CDConfig;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2library.util.Proxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.Nullable;

public class CookingOverlay
implements IGuiOverlay {
    private static final float MAX_TIME = 400.0f;
    private static final float STIR_TIME = 100.0f;
    private static final float R = 9.0f;

    @Nullable
    private static CookingData getHandData() {
        ItemStack stack;
        LocalPlayer player = Proxy.getClientPlayer();
        ItemStack mainStack = player.m_21205_();
        ItemStack offStack = player.m_21206_();
        if (!mainStack.m_41619_() && mainStack.m_150930_((Item)CDItems.SKILLET.get())) {
            stack = mainStack;
        } else if (!offStack.m_41619_() && offStack.m_150930_((Item)CDItems.SKILLET.get())) {
            stack = offStack;
        } else {
            return null;
        }
        return CuisineSkilletItem.getData(stack);
    }

    @Nullable
    private static CookingData getBlockData() {
        HitResult result = Minecraft.m_91087_().f_91077_;
        if (result == null || result.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockPos pos = ((BlockHitResult)result).m_82425_();
        BlockEntity blockEntity = Proxy.getClientWorld().m_7702_(pos);
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            return be.cookingData;
        }
        return null;
    }

    @Nullable
    public static CookingData getData() {
        CookingData itemData = CookingOverlay.getHandData();
        if (itemData != null) {
            return itemData;
        }
        return CookingOverlay.getBlockData();
    }

    public void render(ForgeGui gui, GuiGraphics g, float partialTick, int w, int h) {
        ItemStack food;
        if (Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        CookingData data = CookingOverlay.getData();
        if (data == null || data.contents.isEmpty()) {
            return;
        }
        float scale = (float)((Double)CDConfig.CLIENT.uiScale.get()).doubleValue();
        w = Math.round((float)w / scale);
        h = Math.round((float)h / scale);
        g.m_280168_().m_85836_();
        g.m_280168_().m_85841_(scale, scale, scale);
        data.update(Minecraft.m_91087_().f_91073_.m_46467_());
        int xa = (Integer)CDConfig.CLIENT.uiXAnchor.get();
        int xo = (Integer)CDConfig.CLIENT.uiXOffset.get();
        int ya = (Integer)CDConfig.CLIENT.uiYAnchor.get();
        int yo = (Integer)CDConfig.CLIENT.uiYOffset.get();
        int tw = 68;
        int th = data.contents.size() * 20;
        int x = xo + (xa + 1) * (w - tw) / 2;
        int y = yo + (ya + 1) * (h - th) / 2;
        int ix = x;
        int iy = y;
        Font font = Minecraft.m_91087_().f_91062_;
        for (CookingData.CookingEntry entry : data.contents) {
            food = entry.getItem();
            CookTransform handle = CookTransformConfig.get(food);
            ItemStack render = handle.renderStack(entry.getStage(data), food);
            g.m_280480_(render, ix, iy + 2);
            g.m_280370_(font, render, ix, iy + 2);
            iy += 20;
        }
        ix += 20;
        iy = y;
        for (CookingData.CookingEntry entry : data.contents) {
            food = entry.getItem();
            IngredientConfig.IngredientEntry config = IngredientConfig.get().getEntry(food);
            if (config != null) {
                PieRenderer cook = new PieRenderer(g, ix + 8, iy + 12);
                float min = (float)config.min_time / 400.0f;
                float max = (float)config.max_time / 400.0f;
                cook.fillPie(0.0f, min, PieRenderer.Texture.PIE_GREEN);
                cook.fillPie(min, max, PieRenderer.Texture.PIE_YELLOW);
                cook.fillPie(max, 1.0f, PieRenderer.Texture.PIE_RED);
                float cook_needle = Mth.m_14036_((float)(entry.getDuration(data, partialTick) / 400.0f), (float)0.0f, (float)1.0f);
                cook.drawNeedle(PieRenderer.Texture.NEEDLE_BLACK, cook_needle);
                cook.drawIcon(PieRenderer.Texture.COOK);
                PieRenderer flip = new PieRenderer(g, ix + 28, iy + 12);
                float thr = (float)config.stir_time / 100.0f;
                flip.fillPie(0.0f, thr, PieRenderer.Texture.PIE_GREEN);
                flip.fillPie(thr, 1.0f, PieRenderer.Texture.PIE_RED);
                float stir_current = Mth.m_14036_((float)(entry.timeSinceStir(data, partialTick) / 100.0f), (float)0.0f, (float)1.0f);
                float stir_max = Mth.m_14036_((float)Math.max(stir_current, entry.getMaxStirTime(data) / 100.0f), (float)0.0f, (float)1.0f);
                flip.drawNeedle(PieRenderer.Texture.NEEDLE_BLACK, stir_current);
                flip.drawNeedle(PieRenderer.Texture.NEEDLE_RED, stir_max + 0.5f);
                flip.drawIcon(PieRenderer.Texture.FLIP);
            }
            iy += 20;
        }
        g.m_280168_().m_85849_();
    }
}

