/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.compat;

import dev.xkmc.cuisinedelight.content.item.BaseFoodItem;
import dev.xkmc.cuisinedelight.content.recipe.BaseCuisineRecipe;
import dev.xkmc.cuisinedelight.content.recipe.CuisineRecipeMatch;
import dev.xkmc.cuisinedelight.content.recipe.FoodTypeIngredient;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import dev.xkmc.l2library.serial.recipe.BaseRecipeCategory;
import dev.xkmc.l2serial.util.Wrappers;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class CuisineRecipeCategory
extends BaseRecipeCategory<BaseCuisineRecipe<?>, CuisineRecipeCategory> {
    private IGuiHelper guiHelper;

    public CuisineRecipeCategory() {
        super(new ResourceLocation("cuisinedelight", "cuisine"), (Class)Wrappers.cast(BaseCuisineRecipe.class));
    }

    public CuisineRecipeCategory init(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.background = guiHelper.createBlankDrawable(116, 54);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CDItems.SKILLET.asStack());
        return this;
    }

    public Component getTitle() {
        return LangData.JEI_TITLE.get(new Object[0]);
    }

    public void draw(BaseCuisineRecipe<?> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = this.getWidth();
        int recipeHeight = this.getHeight();
        IDrawableStatic recipeArrow = this.guiHelper.getRecipeArrow();
        recipeArrow.draw(guiGraphics, 61, (54 - recipeArrow.getHeight()) / 2);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BaseCuisineRecipe<?> recipe, IFocusGroup focuses) {
        for (int index = 0; index < 9; ++index) {
            int x = index % 3;
            int y = index / 3;
            IRecipeSlotBuilder r = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1).setStandardSlotBackground();
            if (index >= recipe.list.size()) continue;
            CuisineRecipeMatch e = recipe.list.get(index);
            ((IRecipeSlotBuilder)r.addIngredients(e.ingredient())).addRichTooltipCallback((view, b) -> this.ingredientTooltip(e, view, arg_0 -> ((ITooltipBuilder)b).add(arg_0)));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 95, 19).setOutputSlotBackground().addItemStack(BaseFoodItem.setResultDisplay(recipe, recipe.holderItem.m_7968_()));
    }

    private void ingredientTooltip(CuisineRecipeMatch ingredient, IRecipeSlotView view, Consumer<FormattedText> list) {
        Ingredient ingredient2 = ingredient.ingredient();
        if (ingredient2 instanceof FoodTypeIngredient) {
            FoodTypeIngredient type = (FoodTypeIngredient)ingredient2;
            list.accept((FormattedText)LangData.JEI_FOOD_TYPE.get(type.foodType.get().m_130940_(ChatFormatting.GOLD)));
        }
        int min = (int)Math.round(ingredient.min() * 100.0);
        int max = (int)Math.round(Math.min(ingredient.max(), 1.0) * 100.0);
        String val = max >= 100 ? min + "%+" : min + "%-" + max + "%";
        list.accept((FormattedText)LangData.JEI_INGREDIENT_AMOUNT.get(Component.m_237113_((String)val).m_130940_(ChatFormatting.AQUA)));
    }
}

