/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.client;

import com.mojang.blaze3d.platform.Window;
import com.nameless.impactful.api.client.VFXPropertiesReader;
import com.nameless.impactful.client.IRenderItemBase;
import com.nameless.impactful.config.ClientConfig;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;

@OnlyIn(value=Dist.CLIENT)
public class RadialBlurEngine {
    private static RadialBlurEngine instance;
    private static PostChain blurChain;
    private static final ResourceLocation SHADER;
    private RadialBlur radialBlur;
    private final RadialBlur default_entry = new RadialBlur(2, 0.5f, 0);

    public RadialBlurEngine() {
        instance = this;
    }

    public static RadialBlurEngine getInstance() {
        return instance;
    }

    public void applyRadialBlur(int lifTime, float blurRate, int decay_time) {
        this.radialBlur = new RadialBlur(lifTime, blurRate, decay_time);
        this.reset();
    }

    public void applyRadialBlur(RadialBlur radialBlur) {
        this.radialBlur = radialBlur.copy();
        this.reset();
    }

    public void applyRadialBlurByAnim(int animationId, float elapsedTime) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        RenderItemBase renderitembase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
        this.radialBlur = ((IRenderItemBase)renderitembase).getRadialBlur() != null ? ((IRenderItemBase)renderitembase).getRadialBlur() : this.default_entry;
        Object object = AnimationManager.byId((int)animationId).get();
        if (object instanceof AttackAnimation) {
            AttackAnimation attackAnimation = (AttackAnimation)object;
            this.radialBlur = attackAnimation.getPhaseByTime(elapsedTime).getProperty(VFXPropertiesReader.VFXAnimationProperties.RADIAL_BLUR).orElse(this.radialBlur);
        }
        this.applyRadialBlur(this.radialBlur.lifeTime, this.radialBlur.blurRate, this.radialBlur.decay_time);
    }

    private void reset() {
        if (this.radialBlur == null) {
            return;
        }
        blurChain.m_110025_(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
        EffectInstance effect = ((PostPass)RadialBlurEngine.blurChain.f_110009_.get(0)).m_110074_();
        Window win = Minecraft.m_91087_().m_91268_();
        float centerX = (float)win.m_85441_() * 0.5f / (float)win.m_85443_();
        float centerY = (float)win.m_85442_() * 0.5f / (float)win.m_85444_();
        effect.m_108960_("center").m_7971_(centerX, centerY);
        effect.m_108960_("intensity").m_5985_((float)((double)this.radialBlur.blurRate * (Double)ClientConfig.RADIAL_BLUR_INTENSITY_RATE.get()));
    }

    private void tick(float partialTick) {
        if (this.radialBlur == null) {
            return;
        }
        this.radialBlur.tick();
        EffectInstance effect = ((PostPass)RadialBlurEngine.blurChain.f_110009_.get(0)).m_110074_();
        effect.m_108960_("intensity").m_5985_((float)((double)this.radialBlur.blurRate * (Double)ClientConfig.RADIAL_BLUR_INTENSITY_RATE.get()));
        blurChain.m_110023_(partialTick);
        if (this.radialBlur.removed) {
            this.radialBlur = null;
        }
    }

    static {
        SHADER = ResourceLocation.fromNamespaceAndPath((String)"impactful", (String)"shaders/post/radial_blur.json");
    }

    public static class RadialBlur {
        private int age;
        private final int lifeTime;
        private final int decay_time;
        private boolean removed;
        private float blurRate;

        public RadialBlur(int lifeTime, float blurRate, int decay_time) {
            this.lifeTime = lifeTime;
            this.blurRate = blurRate;
            this.decay_time = decay_time;
        }

        public void tick() {
            ++this.age;
            if (this.age > this.decay_time) {
                this.blurRate *= 0.98f;
            }
            if (this.age > this.lifeTime) {
                this.removed = true;
            }
        }

        public RadialBlur copy() {
            return new RadialBlur(this.lifeTime, this.blurRate, this.decay_time);
        }
    }

    @Mod.EventBusSubscriber(modid="impactful", value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onRenderTick(RenderLevelStageEvent e) throws IOException {
            if (((Boolean)ClientConfig.DISABLE_RADIAL_BLUR.get()).booleanValue()) {
                return;
            }
            if (blurChain == null) {
                blurChain = new PostChain(Minecraft.m_91087_().m_91097_(), Minecraft.m_91087_().m_91098_(), Minecraft.m_91087_().m_91385_(), SHADER);
                blurChain.m_110025_(Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_());
                Window win = Minecraft.m_91087_().m_91268_();
                float centerX = (float)win.m_85441_() * 0.5f / (float)win.m_85443_();
                float centerY = (float)win.m_85442_() * 0.5f / (float)win.m_85444_();
                ((PostPass)RadialBlurEngine.blurChain.f_110009_.get(0)).m_110074_().m_108960_("center").m_7971_(centerX, centerY);
            }
            if (blurChain != null && Minecraft.m_91087_().f_91074_ != null && e.getStage() == RenderLevelStageEvent.Stage.AFTER_LEVEL) {
                instance.tick(e.getPartialTick());
            }
        }
    }
}

