/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.impactful.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.main.EpicFightMod;

public class PropertiesReader {
    public static void readAndApply(StaticAnimation animation, Resource iresource, SubFileType<?> subFileType) {
        InputStream inputstream = null;
        try {
            inputstream = iresource.m_215507_();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        assert (inputstream != null) : "Input stream is null";
        try {
            subFileType.apply(inputstream, animation);
        }
        catch (JsonParseException e) {
            EpicFightMod.LOGGER.warn("Can't read sub file " + subFileType.directory + " for " + animation);
            e.printStackTrace();
        }
    }

    public static ResourceLocation getSubAnimationFileLocation(ResourceLocation location, SubFileType<?> subFileType) {
        int splitIdx = location.m_135815_().lastIndexOf(47);
        if (splitIdx < 0) {
            splitIdx = 0;
        }
        return ResourceLocation.fromNamespaceAndPath((String)location.m_135827_(), (String)String.format("%s/" + subFileType.getDirectory() + "%s", location.m_135815_().substring(0, splitIdx), location.m_135815_().substring(splitIdx)));
    }

    public static abstract class SubFileType<T> {
        private final String directory;
        private final AnimationSubFileDeserializer<T> deserializer;

        public SubFileType(String directory, AnimationSubFileDeserializer<T> deserializer) {
            this.directory = directory;
            this.deserializer = deserializer;
        }

        public void apply(InputStream inputstream, StaticAnimation animation) {
            InputStreamReader reader = new InputStreamReader(inputstream, StandardCharsets.UTF_8);
            JsonReader jsonReader = new JsonReader((Reader)reader);
            jsonReader.setLenient(true);
            T deserialized = this.deserializer.deserialize(animation, Streams.parse((JsonReader)jsonReader));
            this.applySubFileInfo(deserialized, animation);
        }

        protected abstract void applySubFileInfo(T var1, StaticAnimation var2);

        public String getDirectory() {
            return this.directory;
        }
    }

    public static interface AnimationSubFileDeserializer<T> {
        public T deserialize(StaticAnimation var1, JsonElement var2) throws JsonParseException;
    }
}

