/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicparcool.client.event;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.impl.ClingToCliffAnimator;
import com.alrex.parcool.client.animation.impl.DiveAnimationHostAnimator;
import com.alrex.parcool.client.animation.impl.FastRunningAnimator;
import com.alrex.parcool.client.animation.impl.HangAnimator;
import com.alrex.parcool.client.animation.impl.HideInBlockAnimator;
import com.alrex.parcool.client.animation.impl.HorizontalWallRunAnimator;
import com.alrex.parcool.client.animation.impl.JumpChargingAnimator;
import com.alrex.parcool.client.animation.impl.RideZiplineAnimator;
import com.alrex.parcool.client.animation.impl.SlidingAnimator;
import com.alrex.parcool.client.animation.impl.WallSlideAnimator;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.common.action.impl.JumpFromBar;
import com.alrex.parcool.common.action.impl.RideZipline;
import com.alrex.parcool.common.action.impl.VerticalWallRun;
import com.alrex.parcool.common.action.impl.WallJump;
import com.alrex.parcool.common.action.impl.WallSlide;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.utilities.VectorUtil;
import com.google.common.collect.Maps;
import com.yesman.epicparcool.ParCoolUtils;
import com.yesman.epicparcool.ParcoolLivingMotions;
import com.yesman.epicparcool.animations.ParCoolAnimations;
import com.yesman.epicparcool.mixin.ParCoolMixinAnimation;
import com.yesman.epicparcool.mixin.ParCoolMixinDiveAnimationHostAnimator;
import com.yesman.epicparcool.mixin.ParCoolMixinHideInBlockAnimator;
import com.yesman.epicparcool.mixin.ParCoolMixinHorizontalWallRunAnimator;
import com.yesman.epicparcool.mixin.ParCoolMixinRideZiplineAccessor;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@Mod.EventBusSubscriber(modid="epicparcool", value={Dist.CLIENT})
public class ParCoolClientEvents {
    private static final Map<Class<? extends Animator>, LifecycleAnimationLinker> PARCOOL_ANIMATOR_MAPPING = Maps.newHashMap();
    private static final ByteBuffer DUMMY_BUFFER = ByteBuffer.allocate(128);
    private static final UUID EVENT_UUID = UUID.fromString("bc79276d-a0d1-4e58-867f-6bdd25d1ba23");

    public static void onSetup(FMLClientSetupEvent event) {
        PARCOOL_ANIMATOR_MAPPING.clear();
        PARCOOL_ANIMATOR_MAPPING.put(JumpChargingAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CAT_LEAP_PREPARATION));
        PARCOOL_ANIMATOR_MAPPING.put(ClingToCliffAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> livingMotionUpdateEvent.getPlayerPatch().getAnimator().getVariables().getSharedVariable(ParCoolAnimations.CLING_TYPE).ifPresentOrElse(clingDirection -> {
            if (clingDirection == ParCoolUtils.ClingType.OUTER_CORNER) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF_OUTER_CORNER);
            } else if (clingDirection == ParCoolUtils.ClingType.INNER_CORNER) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF_INNER_CORNER);
            } else {
                switch (((ClingToCliff)parkourability.get(ClingToCliff.class)).getFacingDirection()) {
                    case ToWall: {
                        livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF);
                        break;
                    }
                    case LeftAgainstWall: {
                        livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF_LEFT);
                        break;
                    }
                    case RightAgainstWall: {
                        livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF_RIGHT);
                    }
                }
            }
        }, () -> livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.CLING_TO_CLIFF)));
        PARCOOL_ANIMATOR_MAPPING.put(DiveAnimationHostAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            if (((AbstractClientPlayer)livingMotionUpdateEvent.getPlayerPatch().getOriginal()).m_21255_()) {
                return;
            }
            if (((ParCoolMixinDiveAnimationHostAnimator)animator).getSkyDiveAnimator() != null) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.SKY_DIVE);
            } else {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.DIVE);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(WallSlideAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            Vec3 wall = ((WallSlide)parkourability.get(WallSlide.class)).getLeanedWallDirection();
            if (wall == null) {
                return;
            }
            Vec3 bodyVec = VectorUtil.fromYawDegree((double)((AbstractClientPlayer)livingMotionUpdateEvent.getPlayerPatch().getOriginal()).f_20883_);
            Vec3 vec = new Vec3(bodyVec.f_82479_, 0.0, bodyVec.f_82481_).m_82541_();
            Vec3 dividedVec = new Vec3(vec.f_82479_ * wall.f_82479_ + vec.f_82481_ * wall.f_82481_, 0.0, -vec.f_82479_ * wall.f_82481_ + vec.f_82481_ * wall.f_82479_).m_82541_();
            if (dividedVec.f_82481_ < 0.0) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.WALL_SLIDING_RIGHT);
            } else {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.WALL_SLIDING_LEFT);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(HorizontalWallRunAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            if (((ParCoolMixinHorizontalWallRunAnimator)animator).getWallIsRightSide()) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.WALL_RUNNING_RIGHT);
            } else {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.WALL_RUNNING_LEFT);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(FastRunningAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            if (livingMotionUpdateEvent.getMotion() == LivingMotions.RUN) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.FAST_RUN);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(HangAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            HangDown hangDown = (HangDown)parkourability.get(HangDown.class);
            if (hangDown.isOrthogonalToBar()) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.HANG_DOWN_ORTHOGONAL);
            } else {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.HANG_DOWN);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(SlidingAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.SLIDING));
        PARCOOL_ANIMATOR_MAPPING.put(HideInBlockAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            if (!((ParCoolMixinHideInBlockAnimator)animator).getStanding()) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.HIDE_IN_BLOCK_HORIZONTAL);
            }
        });
        PARCOOL_ANIMATOR_MAPPING.put(RideZiplineAnimator.class, (animator, parkourability, livingMotionUpdateEvent) -> {
            LivingMotion oldMotion = livingMotionUpdateEvent.getPlayerPatch().getClientAnimator().currentMotion();
            if (oldMotion == ParcoolLivingMotions.RIDE_ZIPLINE_FORWARD || oldMotion == ParcoolLivingMotions.RIDE_ZIPLINE_SIDE) {
                livingMotionUpdateEvent.setMotion(oldMotion);
                return;
            }
            ParCoolMixinRideZiplineAccessor action = (ParCoolMixinRideZiplineAccessor)parkourability.get(RideZipline.class);
            Vec3 offset = action.getEndOffsetFromStart().m_82541_();
            Vec3 lookVec = VectorUtil.fromYawDegree((double)((AbstractClientPlayer)livingMotionUpdateEvent.getPlayerPatch().getOriginal()).m_146908_());
            double dot = offset.m_82526_(lookVec);
            double yRot = VectorUtil.toYaw((Vec3)offset);
            if (Math.abs(dot) > 0.5) {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.RIDE_ZIPLINE_FORWARD);
                if (dot < 0.0) {
                    yRot += 180.0;
                }
                livingMotionUpdateEvent.getPlayerPatch().setYRot((float)yRot);
            } else {
                livingMotionUpdateEvent.setMotion((LivingMotion)ParcoolLivingMotions.RIDE_ZIPLINE_SIDE);
            }
        });
    }

    @SubscribeEvent
    public static void onJoinWorldEvent(EntityJoinLevelEvent event) {
        PlayerPatch playerpatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), PlayerPatch.class);
        if (playerpatch == null) {
            return;
        }
        playerpatch.getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, skillexecuteevent -> {
            if (skillexecuteevent.getSkillContainer().getSkill() == EpicFightSkills.PHANTOM_ASCENT) {
                Parkourability parkourability = Parkourability.get((Player)((Player)playerpatch.getOriginal()));
                if (((ClingToCliff)parkourability.get(ClingToCliff.class)).isDoing()) {
                    skillexecuteevent.setCanceled(true);
                    return;
                }
                DUMMY_BUFFER.clear();
                if (((WallJump)parkourability.get(WallJump.class)).canStart((Player)playerpatch.getOriginal(), parkourability, IStamina.get((Player)((Player)playerpatch.getOriginal())), DUMMY_BUFFER)) {
                    DUMMY_BUFFER.flip();
                    skillexecuteevent.setCanceled(true);
                    skillexecuteevent.getSkillContainer().getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), (Object)true);
                    return;
                }
                DUMMY_BUFFER.clear();
                if (((VerticalWallRun)parkourability.get(VerticalWallRun.class)).canStart((Player)playerpatch.getOriginal(), parkourability, IStamina.get((Player)((Player)playerpatch.getOriginal())), DUMMY_BUFFER)) {
                    DUMMY_BUFFER.flip();
                    skillexecuteevent.setCanceled(true);
                    skillexecuteevent.getSkillContainer().getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), (Object)true);
                    return;
                }
                DUMMY_BUFFER.clear();
                if (((JumpFromBar)parkourability.get(JumpFromBar.class)).canStart((Player)playerpatch.getOriginal(), parkourability, IStamina.get((Player)((Player)playerpatch.getOriginal())), DUMMY_BUFFER)) {
                    DUMMY_BUFFER.flip();
                    skillexecuteevent.setCanceled(true);
                    skillexecuteevent.getSkillContainer().getDataManager().setData((SkillDataKey)SkillDataKeys.JUMP_KEY_PRESSED_LAST_TICK.get(), (Object)true);
                    return;
                }
            }
        });
    }

    @SubscribeEvent
    public static void onBaseLayerUpdateEvent(UpdatePlayerMotionEvent.BaseLayer event) {
        if (event.inaction()) {
            return;
        }
        ((AbstractClientPlayer)event.getPlayerPatch().getOriginal()).getCapability(Capabilities.ANIMATION_CAPABILITY).ifPresent(animation -> {
            ParCoolMixinAnimation animationAccessor = (ParCoolMixinAnimation)animation;
            Animator animator = animationAccessor.getAnimator();
            Parkourability parkourability = Parkourability.get((Player)((Player)event.getPlayerPatch().getOriginal()));
            if (parkourability != null && animator != null && PARCOOL_ANIMATOR_MAPPING.containsKey(animator.getClass()) && !animator.shouldRemoved((Player)event.getPlayerPatch().getOriginal(), parkourability)) {
                PARCOOL_ANIMATOR_MAPPING.get(animator.getClass()).accept(animator, parkourability, event);
            }
        });
    }

    @SubscribeEvent
    public static void onMovementInputUpdateEvent(MovementInputUpdateEvent event) {
        LocalPlayerPatch playerpatch = (LocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), LocalPlayerPatch.class);
        if (playerpatch == null || !playerpatch.isEpicFightMode()) {
            return;
        }
        Parkourability parkourability = Parkourability.get((Player)event.getEntity());
        HangDown hangDown = (HangDown)parkourability.get(HangDown.class);
        if (hangDown != null && hangDown.isDoing()) {
            if (!playerpatch.getEntityState().inaction()) {
                float yRot = ParCoolUtils.idealYRotForHanging(hangDown, event.getEntity());
                HangDown.BarAxis barAxis = hangDown.getHangingBarAxis();
                boolean axisMismatches = false;
                if (hangDown.isOrthogonalToBar()) {
                    if (barAxis == ParCoolUtils.getLookBarAxis(yRot)) {
                        axisMismatches = true;
                    }
                } else if (barAxis != ParCoolUtils.getLookBarAxis(yRot)) {
                    axisMismatches = true;
                }
                if (!axisMismatches) {
                    playerpatch.setModelYRot(yRot, true);
                    AnimationManager.AnimationAccessor<ActionAnimation> animationAccessor = null;
                    AnimationManager.AnimationAccessor<ActionAnimation> endAnimationAccessor = null;
                    if (hangDown.isOrthogonalToBar()) {
                        if (event.getInput().f_108570_) {
                            animationAccessor = ParCoolAnimations.BIPED_HANG_DOWN_MOVE_LEFT;
                        } else if (event.getInput().f_108571_) {
                            animationAccessor = ParCoolAnimations.BIPED_HANG_DOWN_MOVE_RIGHT;
                        }
                    } else if (event.getInput().f_108568_) {
                        animationAccessor = ParCoolAnimations.BIPED_HANG_DOWN_MOVE_FORWARD_START;
                        endAnimationAccessor = ParCoolAnimations.BIPED_HANG_DOWN_MOVE_FORWARD_END1;
                    } else if (event.getInput().f_108569_) {
                        animationAccessor = ParCoolAnimations.BIPED_HANG_DOWN_MOVE_BACKWARD;
                    }
                    if (animationAccessor != null) {
                        Vec3 hangDownDest;
                        Vec3 simulatedMove = ((ActionAnimation)animationAccessor.get()).getExpectedMovement((LivingEntityPatch)playerpatch, ((ActionAnimation)animationAccessor.get()).getTotalTime());
                        if (endAnimationAccessor != null) {
                            simulatedMove = simulatedMove.m_82549_(((ActionAnimation)endAnimationAccessor.get()).getExpectedMovement((LivingEntityPatch)playerpatch, ((ActionAnimation)endAnimationAccessor.get()).getTotalTime()));
                        }
                        if ((hangDownDest = ParCoolUtils.getHangableBars((LivingEntity)playerpatch.getOriginal(), simulatedMove)) != null) {
                            playerpatch.playAnimationSynchronized(animationAccessor, 0.0f);
                        }
                    }
                }
            }
            event.getInput().f_108570_ = false;
            event.getInput().f_108571_ = false;
            event.getInput().f_108568_ = false;
            event.getInput().f_108569_ = false;
            event.getInput().f_108567_ = 0.0f;
            event.getInput().f_108566_ = 0.0f;
            event.getEntity().m_20334_(0.0, 0.0, 0.0);
        } else if (((ClingToCliff)parkourability.get(ClingToCliff.class)).isDoing()) {
            if (!playerpatch.getEntityState().inaction()) {
                if (event.getInput().f_108570_) {
                    ParCoolUtils.scanTerrainAndStartClingAction(playerpatch, ParCoolUtils.WallMoveType.MOVE_LEFT);
                } else if (event.getInput().f_108571_) {
                    ParCoolUtils.scanTerrainAndStartClingAction(playerpatch, ParCoolUtils.WallMoveType.MOVE_RIGHT);
                }
            }
            event.getInput().f_108570_ = false;
            event.getInput().f_108571_ = false;
            event.getInput().f_108568_ = false;
            event.getInput().f_108569_ = false;
            event.getInput().f_108567_ = 0.0f;
            event.getInput().f_108566_ = 0.0f;
        }
    }

    @FunctionalInterface
    public static interface LifecycleAnimationLinker {
        public void accept(Animator var1, Parkourability var2, UpdatePlayerMotionEvent.BaseLayer var3);
    }
}

