/*
 * Decompiled with CFR 0.152.
 */
package com.yesman.epicparcool;

import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.utilities.VectorUtil;
import com.yesman.epicparcool.animations.ParCoolAnimations;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class ParCoolUtils {
    public static float idealYRotForHanging(HangDown action, Player player) {
        Vec3 bodyVec = VectorUtil.fromYawDegree((double)player.f_20883_).m_82541_();
        Vec3 lookVec = player.m_20154_();
        Vec3 idealLookVec = Math.abs(lookVec.f_82479_) > Math.abs(lookVec.f_82481_) ? new Vec3(lookVec.f_82479_ > 0.0 ? 1.0 : -1.0, 0.0, 0.0) : new Vec3(0.0, 0.0, lookVec.f_82481_ > 0.0 ? 1.0 : -1.0);
        double differenceAngle = Math.acos(bodyVec.m_82526_(idealLookVec));
        return (float)VectorUtil.toYawDegree((Vec3)idealLookVec.m_82524_((float)(differenceAngle /= 4.0)));
    }

    public static Vec3 getHangableBars(LivingEntity entity, Vec3 simulateNextPos) {
        Vec3 entityPos = entity.m_20182_();
        boolean posChanged = false;
        if (!Vec3.f_82478_.equals((Object)simulateNextPos)) {
            entity.m_146884_(entityPos.m_82549_(simulateNextPos));
            posChanged = true;
        }
        double bbWidth = entity.m_20205_() / 4.0f;
        double bbHeight = 0.35;
        AABB bb = new AABB(entity.m_20185_() - bbWidth, entity.m_20186_() + (double)entity.m_20206_(), entity.m_20189_() - bbWidth, entity.m_20185_() + bbWidth, entity.m_20186_() + (double)entity.m_20206_() + bbHeight, entity.m_20189_() + bbWidth);
        if (entity.m_20193_().m_45756_((Entity)entity, bb)) {
            if (posChanged) {
                entity.m_146884_(entityPos);
            }
            return null;
        }
        BlockPos pos = new BlockPos((int)Math.floor(entity.m_20185_()), (int)Math.floor(entity.m_20186_() + (double)entity.m_20206_() + 0.4), (int)Math.floor(entity.m_20189_()));
        if (!entity.m_20193_().m_46749_(pos)) {
            if (posChanged) {
                entity.m_146884_(entityPos);
            }
            return null;
        }
        BlockState state = entity.m_20193_().m_8055_(pos);
        Block block = state.m_60734_();
        HangDown.BarAxis axis = null;
        if (block instanceof RotatedPillarBlock) {
            if (state.m_60838_((BlockGetter)entity.m_20193_(), pos)) {
                if (posChanged) {
                    entity.m_146884_(entityPos);
                }
                return null;
            }
            Direction.Axis pillarAxis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
            switch (pillarAxis) {
                case X: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case Z: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof DirectionalBlock) {
            if (state.m_60838_((BlockGetter)entity.m_20193_(), pos)) {
                if (posChanged) {
                    entity.m_146884_(entityPos);
                }
                return null;
            }
            Direction direction = (Direction)state.m_61143_((Property)DirectionalBlock.f_52588_);
            switch (direction) {
                case EAST: 
                case WEST: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof CrossCollisionBlock) {
            int zCount = 0;
            xCount = 0;
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52309_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52311_)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52310_)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.m_61143_((Property)CrossCollisionBlock.f_52312_)).booleanValue()) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        } else if (block instanceof WallBlock) {
            int zCount = 0;
            xCount = 0;
            if (state.m_61143_((Property)WallBlock.f_57951_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57952_) != WallSide.NONE) {
                ++zCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57950_) != WallSide.NONE) {
                ++xCount;
            }
            if (state.m_61143_((Property)WallBlock.f_57953_) != WallSide.NONE) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        }
        Vec3 simulatedDestPosition = entity.m_20182_();
        if (posChanged) {
            entity.m_146884_(entityPos);
        }
        if (axis == null) {
            return null;
        }
        VoxelShape shape = state.m_60812_((BlockGetter)entity.m_9236_(), pos);
        double min = (double)pos.m_123342_() - (0.5 - shape.m_83288_(Direction.Axis.Y));
        switch (axis) {
            case X: {
                return new Vec3(simulatedDestPosition.f_82479_, min, (double)pos.m_123343_() + 0.5);
            }
            case Z: {
                return new Vec3((double)pos.m_123341_() + 0.5, min, simulatedDestPosition.f_82481_);
            }
        }
        return null;
    }

    public static void spawnJumpParticles(LivingEntity entity, Vec3 wallDirection, Vec3 jumpDirection) {
        Vec3 pos;
        BlockPos leanedBlock;
        Level level = entity.m_9236_();
        if (!level.m_46749_(leanedBlock = new BlockPos((int)Math.floor((pos = entity.m_20182_()).m_7096_() + wallDirection.m_7096_()), (int)Math.floor(pos.m_7098_() + (double)entity.m_20206_() * 0.25), (int)Math.floor(pos.m_7094_() + wallDirection.m_7094_())))) {
            return;
        }
        float width = entity.m_20205_();
        BlockState blockstate = level.m_8055_(leanedBlock);
        Vec3 horizontalJumpDirection = jumpDirection.m_82542_(1.0, 0.0, 1.0).m_82541_();
        wallDirection = wallDirection.m_82541_();
        Vec3 orthogonalToWallVec = wallDirection.m_82524_(1.5707964f).m_82541_();
        Vec3 differenceVec = new Vec3(-wallDirection.m_7096_() * horizontalJumpDirection.m_7096_() - wallDirection.m_7094_() * horizontalJumpDirection.m_7094_(), 0.0, wallDirection.m_7094_() * horizontalJumpDirection.m_7096_() - wallDirection.m_7096_() * horizontalJumpDirection.m_7094_()).m_82542_(1.0, 0.0, -1.0).m_82541_();
        Vec3 particleBaseDirection = new Vec3(-wallDirection.m_7096_() * differenceVec.m_7096_() + wallDirection.m_7094_() * differenceVec.m_7094_(), 0.0, -wallDirection.m_7096_() * differenceVec.m_7094_() - wallDirection.m_7094_() * differenceVec.m_7096_());
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 10; ++i) {
                Vec3 particlePos = new Vec3(pos.m_7096_() + (wallDirection.m_7096_() * 0.4 + orthogonalToWallVec.m_7096_() * (entity.m_217043_().m_188500_() - 0.5)) * (double)width, pos.m_7098_() + 0.1 + 0.3 * entity.m_217043_().m_188500_(), pos.m_7094_() + (wallDirection.m_7094_() * 0.4 + orthogonalToWallVec.m_7094_() * (entity.m_217043_().m_188500_() - 0.5)) * (double)width);
                Vec3 particleSpeed = particleBaseDirection.m_82524_((float)(0.6283185307179586 * (entity.m_217043_().m_188500_() - 0.5))).m_82490_(3.0 + 9.0 * entity.m_217043_().m_188500_()).m_82520_(0.0, -jumpDirection.m_7098_() * 3.0 * entity.m_217043_().m_188500_(), 0.0);
                level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(leanedBlock), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
            }
        }
    }

    public static HangDown.BarAxis getLookBarAxis(float rotation) {
        return Math.abs((rotation = Math.abs(Mth.m_14177_((float)rotation))) - 90.0f) > 45.0f ? HangDown.BarAxis.Z : HangDown.BarAxis.X;
    }

    public static ScanResult getCollidingPos(Entity entity, Level level, AABB above, AABB below, Vec3 directionsuppose, double xExpand, double zExpand) {
        if (!level.m_45756_(entity, above.m_82363_(xExpand, 0.0, zExpand))) {
            return null;
        }
        AABB expandedBelow = below.m_82363_(xExpand, 0.0, zExpand);
        VoxelShape shapeSum = Shapes.m_83040_();
        double touchingHeight = -100.0;
        for (VoxelShape voxelshape : level.m_186434_(entity, expandedBelow)) {
            if (voxelshape.m_83281_()) continue;
            for (AABB aabb2 : voxelshape.m_83299_()) {
                if (!aabb2.m_82381_(expandedBelow)) continue;
                if (touchingHeight < aabb2.f_82292_) {
                    touchingHeight = aabb2.f_82292_;
                }
                shapeSum = Shapes.m_83110_((VoxelShape)shapeSum, (VoxelShape)Shapes.m_83064_((AABB)aabb2));
            }
        }
        if (shapeSum.m_83281_()) {
            return null;
        }
        VoxelShape visualShapeSum = Shapes.m_83040_();
        AABB visualBB = entity.m_20191_().m_82377_(0.2, 0.0, 0.2);
        visualBB.m_165893_(below.f_82292_);
        for (VoxelShape voxelshape : level.m_186434_(entity, visualBB)) {
            if (voxelshape.m_83281_()) continue;
            for (Object aabb3 : voxelshape.m_83299_()) {
                if (!aabb3.m_82381_(visualBB)) continue;
                visualShapeSum = Shapes.m_83110_((VoxelShape)visualShapeSum, (VoxelShape)Shapes.m_83064_((AABB)aabb3));
            }
        }
        AABB visualAbove = visualBB.m_165893_(above.f_82292_).m_165887_(above.f_82289_);
        ArrayList<AABB> shapeBBs = new ArrayList<AABB>(visualShapeSum.m_83299_());
        ArrayList<AABB> ungrabbableBBs = new ArrayList<AABB>();
        shapeBBs.removeIf(aabb -> aabb.m_82381_(visualAbove));
        visualShapeSum = Shapes.m_83040_();
        for (AABB aabb4 : shapeBBs) {
            if (Double.compare(aabb4.f_82292_, touchingHeight) == 0) {
                visualShapeSum = Shapes.m_83110_((VoxelShape)visualShapeSum, (VoxelShape)Shapes.m_83064_((AABB)aabb4));
                continue;
            }
            ungrabbableBBs.add(aabb4);
        }
        AABB entityBB = entity.m_20191_().m_165897_(0.01, 0.0, 0.01).m_82310_(0.0, (double)entity.m_20206_() * 0.5, 0.0);
        boolean destBlocked = false;
        for (AABB aabb5 : ungrabbableBBs) {
            destBlocked |= aabb5.m_82381_(entityBB);
        }
        if (destBlocked) {
            return null;
        }
        AABB shapeBound = shapeSum.m_83215_();
        if (xExpand != 0.0 && zExpand == 0.0) {
            double xCollide;
            double d = xCollide = xExpand > 0.0 ? shapeBound.f_82288_ : shapeBound.f_82291_;
            if (visualShapeSum.m_83288_(Direction.Axis.Z) < visualBB.f_82290_ && visualShapeSum.m_83297_(Direction.Axis.Z) > visualBB.f_82293_) {
                return new ScanResult(directionsuppose, new Vec3(xCollide, shapeBound.f_82292_, entity.m_20189_()), ClingType.STRAIGHT);
            }
            if (entity.m_20189_() - shapeBound.f_82290_ < 0.25) {
                return new ScanResult(directionsuppose.m_82520_(0.0, 0.0, 1.0), new Vec3(xCollide, shapeBound.f_82292_, shapeBound.f_82290_), ClingType.OUTER_CORNER);
            }
            if (shapeBound.f_82293_ - entity.m_20189_() < 0.25) {
                return new ScanResult(directionsuppose.m_82520_(0.0, 0.0, -1.0), new Vec3(xCollide, shapeBound.f_82292_, shapeBound.f_82293_), ClingType.OUTER_CORNER);
            }
            return new ScanResult(directionsuppose, new Vec3(xCollide, shapeBound.f_82292_, shapeBound.f_82290_ + (shapeBound.f_82293_ - shapeBound.f_82290_) * 0.5), ClingType.STRAIGHT);
        }
        if (xExpand == 0.0 && zExpand != 0.0) {
            double zCollide;
            double d = zCollide = zExpand > 0.0 ? shapeBound.f_82290_ : shapeBound.f_82293_;
            if (visualShapeSum.m_83288_(Direction.Axis.X) < visualBB.f_82288_ && visualShapeSum.m_83297_(Direction.Axis.X) > visualBB.f_82291_) {
                return new ScanResult(directionsuppose, new Vec3(entity.m_20185_(), shapeBound.f_82292_, zCollide), ClingType.STRAIGHT);
            }
            if (entity.m_20185_() - shapeBound.f_82288_ < 0.25) {
                return new ScanResult(directionsuppose.m_82520_(1.0, 0.0, 0.0), new Vec3(shapeBound.f_82288_, shapeBound.f_82292_, zCollide), ClingType.OUTER_CORNER);
            }
            if (shapeBound.f_82291_ - entity.m_20185_() < 0.25) {
                return new ScanResult(directionsuppose.m_82520_(-1.0, 0.0, 0.0), new Vec3(shapeBound.f_82291_, shapeBound.f_82292_, zCollide), ClingType.OUTER_CORNER);
            }
            return new ScanResult(directionsuppose, new Vec3(shapeBound.f_82288_ + (shapeBound.f_82291_ - shapeBound.f_82288_) * 0.5, shapeBound.f_82292_, zCollide), ClingType.STRAIGHT);
        }
        double xCollide = xExpand > 0.0 ? shapeBound.f_82288_ : shapeBound.f_82291_;
        double zCollide = zExpand > 0.0 ? shapeBound.f_82290_ : shapeBound.f_82293_;
        return new ScanResult(directionsuppose, new Vec3(xCollide, shapeBound.f_82292_, zCollide), ClingType.OUTER_CORNER);
    }

    public static ScanResult getGrabbableWall(Entity entity, Vec3 simulateNextPos) {
        double baseLine1 = entity.m_20192_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        double baseLine2 = entity.m_20206_() + (entity.m_20206_() - entity.m_20192_()) / 2.0f;
        ScanResult wall = ParCoolUtils.getGrabbableWall(entity, simulateNextPos, baseLine1);
        if (wall != null) {
            return wall;
        }
        return ParCoolUtils.getGrabbableWall(entity, simulateNextPos, baseLine2);
    }

    public static ScanResult getGrabbableWall(Entity entity, Vec3 simulateNextPos, double hangHeight) {
        Vec3 pos = entity.m_20182_();
        Level level = entity.m_20193_();
        boolean posChanged = false;
        if (!Vec3.f_82478_.equals((Object)simulateNextPos)) {
            entity.m_146884_(pos.m_82549_(simulateNextPos));
            posChanged = true;
        }
        double expandingSize = (double)entity.m_20205_() * 0.49;
        Vec3 start = entity.m_20182_();
        AABB belowHangHeight = new AABB(start.m_7096_() - expandingSize, start.m_7098_() + hangHeight - (double)(entity.m_20206_() / 6.0f), start.m_7094_() - expandingSize, start.m_7096_() + expandingSize, start.m_7098_() + hangHeight, start.m_7094_() + expandingSize);
        AABB aboveHangHeight = new AABB(start.m_7096_() - expandingSize, start.m_7098_() + hangHeight, start.m_7094_() - expandingSize, start.m_7096_() + expandingSize, start.m_7098_() + (double)entity.m_20206_(), start.m_7094_() + expandingSize);
        double checkingExpandSize = (double)entity.m_20205_() * 0.5;
        ScanResult xScanResult = null;
        ScanResult zScanResult = null;
        ScanResult scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(1.0, 0.0, 0.0), checkingExpandSize, 0.0);
        if (scanResult != null) {
            xScanResult = scanResult;
        } else {
            scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(-1.0, 0.0, 0.0), -checkingExpandSize, 0.0);
            if (scanResult != null) {
                xScanResult = scanResult;
            }
        }
        scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(0.0, 0.0, 1.0), 0.0, checkingExpandSize);
        if (scanResult != null) {
            zScanResult = scanResult;
        } else {
            scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(0.0, 0.0, -1.0), 0.0, -checkingExpandSize);
            if (scanResult != null) {
                zScanResult = scanResult;
            }
        }
        if (xScanResult != null || zScanResult != null) {
            if (xScanResult != null && zScanResult != null) {
                Vec3 wall = xScanResult.grabDirection.m_82549_(zScanResult.grabDirection);
                scanResult = new ScanResult(new Vec3((double)MathUtils.getSign((double)wall.f_82479_), 0.0, (double)MathUtils.getSign((double)wall.f_82481_)), new Vec3(xScanResult.grabPosition().f_82479_, xScanResult.grabPosition().f_82480_, zScanResult.grabPosition().f_82481_), ClingType.INNER_CORNER);
            } else {
                scanResult = (ScanResult)ParseUtil.nvl((Object)xScanResult, (Object)zScanResult);
            }
            if (posChanged) {
                entity.m_146884_(pos);
            }
            return scanResult;
        }
        scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(1.0, 0.0, 1.0), checkingExpandSize, checkingExpandSize);
        if (scanResult == null && (scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(-1.0, 0.0, 1.0), -checkingExpandSize, checkingExpandSize)) == null && (scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(1.0, 0.0, -1.0), checkingExpandSize, -checkingExpandSize)) == null) {
            scanResult = ParCoolUtils.getCollidingPos(entity, level, aboveHangHeight, belowHangHeight, new Vec3(-1.0, 0.0, -1.0), -checkingExpandSize, -checkingExpandSize);
        }
        if (posChanged) {
            entity.m_146884_(pos);
        }
        return scanResult;
    }

    @Nullable
    public static boolean scanTerrainAndStartClingAction(PlayerPatch<?> playerpatch, WallMoveType moveType) {
        if (!KeyBindings.getKeyGrabWall().m_90857_()) {
            return false;
        }
        LivingEntity entity = (LivingEntity)playerpatch.getOriginal();
        double hangHeight = (double)entity.m_20206_() + (double)(entity.m_20206_() - entity.m_20192_()) * 0.5;
        Level world = entity.m_20193_();
        switch (moveType) {
            case CLING_START: {
                ScanResult scanResult = ParCoolUtils.getGrabbableWall((Entity)entity, Vec3.f_82478_);
                if (scanResult == null) {
                    return false;
                }
                Vec3 currentAdjacentWall = scanResult.grabDirection();
                ClingType clingType = scanResult.clingType();
                Vec3 collideHandPos = scanResult.grabPosition();
                BlockPos blockPos = new BlockPos((int)Math.floor(entity.m_20185_() + currentAdjacentWall.f_82479_), (int)(entity.m_20191_().f_82289_ + hangHeight - 0.3), (int)Math.floor(entity.m_20189_() + currentAdjacentWall.f_82481_));
                BlockPos grabbingBlockPos = blockPos.m_7495_();
                if (!world.m_46749_(grabbingBlockPos)) {
                    return false;
                }
                BlockState grabbingBlockState = world.m_8055_(grabbingBlockPos);
                float slipperiness = grabbingBlockState.getFriction((LevelReader)world, grabbingBlockPos, (Entity)entity);
                if ((double)slipperiness > 0.9) {
                    return false;
                }
                float destYRot = (float)Mth.m_14175_((double)MathUtils.getYRotOfVector((Vec3)currentAdjacentWall));
                AnimationManager.AnimationAccessor<ActionAnimation> startAnimation = null;
                if (clingType == ClingType.STRAIGHT) {
                    startAnimation = ParCoolAnimations.BIPED_CLING_START;
                    playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLING_DESTINATION, startAnimation, (Object)collideHandPos);
                } else if (clingType == ClingType.INNER_CORNER) {
                    startAnimation = ParCoolAnimations.BIPED_CLING_START_INNER_CORNER;
                    playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CORNER_CLING_DESTINATION, (Object)collideHandPos);
                } else if (clingType == ClingType.OUTER_CORNER) {
                    startAnimation = ParCoolAnimations.BIPED_CLING_START_OUTER_CORNER;
                    playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CORNER_CLING_DESTINATION, (Object)collideHandPos);
                }
                playerpatch.setModelYRot(destYRot, true);
                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(destYRot));
                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLING_TYPE, (Object)clingType);
                playerpatch.playAnimationSynchronized(startAnimation, 0.0f);
                break;
            }
            case MOVE_LEFT: 
            case MOVE_RIGHT: {
                ClingType currentDirection = (ClingType)((Object)playerpatch.getAnimator().getVariables().getOrDefaultSharedVariable(ParCoolAnimations.CLING_TYPE));
                block4 : switch (currentDirection) {
                    case INNER_CORNER: {
                        float currentYRot = playerpatch.getYRot();
                        float moveYRot = Mth.m_14177_((float)(currentYRot + (moveType == WallMoveType.MOVE_LEFT ? -45.0f : 45.0f)));
                        AnimationManager.AnimationAccessor<ActionAnimation> cornerMoveAnimation = moveType == WallMoveType.MOVE_LEFT ? ParCoolAnimations.BIPED_CLING_MOVE_LEFT_INNER_CORNER2 : ParCoolAnimations.BIPED_CLING_MOVE_RIGHT_INNER_CORNER2;
                        playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_START_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(currentYRot));
                        playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_DEST_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(moveYRot));
                        playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(moveYRot));
                        Vec3 moveVec = ((ActionAnimation)cornerMoveAnimation.get()).getExpectedMovement(playerpatch, ((ActionAnimation)cornerMoveAnimation.get()).getTotalTime());
                        if (world.m_45772_(((Player)playerpatch.getOriginal()).m_20191_().m_82310_(0.1, 0.0, 0.1).m_82383_(moveVec))) {
                            playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLING_TYPE, (Object)ClingType.STRAIGHT);
                            playerpatch.playAnimationSynchronized(cornerMoveAnimation, 0.0f);
                            break;
                        }
                        playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(currentYRot));
                        break;
                    }
                    case OUTER_CORNER: {
                        float currentYRot = playerpatch.getYRot();
                        float destYRot = Mth.m_14177_((float)(currentYRot + (moveType == WallMoveType.MOVE_LEFT ? -45.0f : 45.0f)));
                        float moveYRot = Mth.m_14177_((float)(currentYRot + (moveType == WallMoveType.MOVE_LEFT ? 45.0f : -45.0f)));
                        AnimationManager.AnimationAccessor<ActionAnimation> cornerMoveAnimation = moveType == WallMoveType.MOVE_LEFT ? ParCoolAnimations.BIPED_CLING_MOVE_LEFT_OUTER_CORNER2 : ParCoolAnimations.BIPED_CLING_MOVE_RIGHT_OUTER_CORNER2;
                        playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_START_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(currentYRot));
                        playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_DEST_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(destYRot));
                        playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(moveYRot));
                        Vec3 moveVec = ((ActionAnimation)cornerMoveAnimation.get()).getExpectedMovement(playerpatch, ((ActionAnimation)cornerMoveAnimation.get()).getTotalTime());
                        if (world.m_45772_(((Player)playerpatch.getOriginal()).m_20191_().m_82310_(0.1, 0.0, 0.1).m_82383_(moveVec))) {
                            playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLING_TYPE, (Object)ClingType.STRAIGHT);
                            playerpatch.playAnimationSynchronized(cornerMoveAnimation, 0.0f);
                            break;
                        }
                        playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(currentYRot));
                        break;
                    }
                    case STRAIGHT: {
                        float moveYRot = Mth.m_14177_((float)(playerpatch.getYRot() + (moveType == WallMoveType.MOVE_LEFT ? -90.0f : 90.0f)));
                        Vec3 moveVec = VectorUtil.fromYawDegree((double)moveYRot).m_82490_(0.637184);
                        HangDown.BarAxis axis = ParCoolUtils.getLookBarAxis(moveYRot);
                        boolean destBlocked = !world.m_45772_(entity.m_20191_().m_82377_(axis == HangDown.BarAxis.X ? 0.2 : 0.0, 0.0, axis == HangDown.BarAxis.Z ? 0.2 : 0.0).m_82383_(moveVec));
                        ScanResult scanResult = destBlocked ? ParCoolUtils.getGrabbableWall((Entity)entity, Vec3.f_82478_) : ParCoolUtils.getGrabbableWall((Entity)entity, moveVec);
                        if (scanResult == null) {
                            return false;
                        }
                        ClingType clingType = !destBlocked && scanResult.clingType() == ClingType.INNER_CORNER ? ClingType.STRAIGHT : scanResult.clingType();
                        playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLING_TYPE, (Object)clingType);
                        switch (clingType) {
                            case INNER_CORNER: {
                                AnimationManager.AnimationAccessor<ActionAnimation> cornerMoveAnimation = moveType == WallMoveType.MOVE_LEFT ? ParCoolAnimations.BIPED_CLING_MOVE_LEFT_INNER_CORNER1 : ParCoolAnimations.BIPED_CLING_MOVE_RIGHT_INNER_CORNER1;
                                float visualYRot = Mth.m_14177_((float)(playerpatch.getYRot() + (moveType == WallMoveType.MOVE_LEFT ? -45.0f : 45.0f)));
                                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CORNER_CLING_DESTINATION, (Object)scanResult.grabPosition);
                                playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_START_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(playerpatch.getYRot()));
                                playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_DEST_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(moveYRot));
                                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(visualYRot));
                                playerpatch.playAnimationSynchronized(cornerMoveAnimation, 0.0f);
                                break block4;
                            }
                            case OUTER_CORNER: {
                                AnimationManager.AnimationAccessor<ActionAnimation> cornerMoveAnimation = moveType == WallMoveType.MOVE_LEFT ? ParCoolAnimations.BIPED_CLING_MOVE_LEFT_OUTER_CORNER1 : ParCoolAnimations.BIPED_CLING_MOVE_RIGHT_OUTER_CORNER1;
                                float visualYRot = Mth.m_14177_((float)(playerpatch.getYRot() + (moveType == WallMoveType.MOVE_LEFT ? 45.0f : -45.0f)));
                                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CORNER_CLING_DESTINATION, (Object)scanResult.grabPosition);
                                playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_START_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(playerpatch.getYRot()));
                                playerpatch.getAnimator().getVariables().put(ParCoolAnimations.CLIFF_DEST_Y_ROT, cornerMoveAnimation, (Object)Float.valueOf(playerpatch.getYRot()));
                                playerpatch.getAnimator().getVariables().putSharedVariable(ParCoolAnimations.CLIFF_Y_ROT, (Object)Float.valueOf(visualYRot));
                                playerpatch.playAnimationSynchronized(cornerMoveAnimation, 0.0f);
                                break block4;
                            }
                            case STRAIGHT: {
                                AnimationManager.AnimationAccessor<ActionAnimation> moveAnimation = moveType == WallMoveType.MOVE_LEFT ? ParCoolAnimations.BIPED_CLING_MOVE_LEFT : ParCoolAnimations.BIPED_CLING_MOVE_RIGHT;
                                playerpatch.playAnimationSynchronized(moveAnimation, 0.0f);
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid Cling Type");
            }
        }
        return true;
    }

    public record ScanResult(Vec3 grabDirection, Vec3 grabPosition, ClingType clingType) {
    }

    public static enum ClingType {
        STRAIGHT(false),
        INNER_CORNER(true),
        OUTER_CORNER(true);

        boolean diagonal;

        private ClingType(boolean diagonal) {
            this.diagonal = diagonal;
        }

        public boolean diagonal() {
            return this.diagonal;
        }
    }

    public static enum WallMoveType {
        CLING_START,
        MOVE_LEFT,
        MOVE_RIGHT;

    }
}

