/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.create_bbq.interaction_points;

import com.mao.barbequesdelight.content.block.GrillBlockEntity;
import com.mao.barbequesdelight.content.item.SeasoningItem;
import com.mao.barbequesdelight.init.food.BBQSeasoning;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GrillArmInteractionPoint
extends ArmInteractionPoint {
    public GrillArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.m_82514_((Vec3i)this.pos, (double)1.0);
    }

    public int getSlotCount() {
        return 1;
    }

    public ItemStack insert(ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.m_7702_(this.pos);
        if (blockEntity instanceof GrillBlockEntity) {
            GrillBlockEntity be = (GrillBlockEntity)blockEntity;
            ItemStack input = stack.m_41777_();
            if (!input.m_41619_()) {
                if (be.isHeated()) {
                    GrillBlockEntity.ItemEntry[] itemEntryArray = input.m_41720_();
                    if (itemEntryArray instanceof SeasoningItem) {
                        SeasoningItem seasoningItem = (SeasoningItem)itemEntryArray;
                        for (GrillBlockEntity.ItemEntry itemEntry : be.entries) {
                            if (!seasoningItem.canSprinkle(itemEntry.stack) || !itemEntry.flipped || itemEntry.burnt) continue;
                            if (simulate) {
                                input.m_41774_(1);
                                return input;
                            }
                            this.sprinkle(stack, itemEntry.stack, seasoningItem.getSeasoning());
                            be.inventoryChanged();
                            return stack;
                        }
                    }
                    int slot = -1;
                    int emptyCount = 0;
                    for (int i = 0; i < be.size(); ++i) {
                        if (!be.getStack(i).m_41619_()) continue;
                        slot = i;
                        ++emptyCount;
                    }
                    if (slot != -1) {
                        if (simulate) {
                            input.m_41774_(1);
                            return input;
                        }
                        if (be.addItem(slot, stack)) {
                            return stack;
                        }
                    }
                    if (emptyCount == 0) {
                        for (GrillBlockEntity.ItemEntry itemEntry : be.entries) {
                            if (!itemEntry.canFlip()) continue;
                            if (!simulate) {
                                itemEntry.flip(be);
                            } else {
                                input.m_41774_(1);
                            }
                            return input;
                        }
                    }
                }
                return stack;
            }
        }
        return stack;
    }

    public void sprinkle(ItemStack self, ItemStack skewer, BBQSeasoning seasoning) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            skewer.m_41784_().m_128359_("seasoning", seasoning.name());
            this.level.m_6263_(null, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.75, (double)this.pos.m_123343_() + 0.5, SoundEvents.f_12331_, SoundSource.BLOCKS, 1.0f, 1.0f);
            Integer color = seasoning.color.m_126665_();
            int col = color == null ? 0 : color;
            sl.m_8767_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)col).m_252839_(), 1.0f), (double)this.pos.m_123341_() + 0.5, (double)(this.pos.m_123342_() + 1), (double)this.pos.m_123343_() + 0.5, 8, 0.0, 0.0, 0.0, 1.0);
            self.m_41774_(1);
        }
    }

    public ItemStack extract(int slot, int amount, boolean simulate) {
        GrillBlockEntity.ItemEntry[] itemEntryArray = this.level.m_7702_(this.pos);
        if (itemEntryArray instanceof GrillBlockEntity) {
            GrillBlockEntity be = (GrillBlockEntity)itemEntryArray;
            for (GrillBlockEntity.ItemEntry itemEntry : be.entries) {
                if (itemEntry.time <= itemEntry.duration) continue;
                if (!simulate) {
                    ItemStack toReturn = itemEntry.stack.m_278832_();
                    be.inventoryChanged();
                    return toReturn;
                }
                return itemEntry.stack.m_41777_();
            }
        }
        return ItemStack.f_41583_;
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.m_7702_(pos) instanceof GrillBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new GrillArmInteractionPoint(this, level, pos, state);
        }
    }
}

