/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.util.math;

import com.finderfeed.fdlib.FDLibCalls;
import com.finderfeed.fdlib.data_structures.Pair;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FDMathUtil {
    public static final float FPI = (float)Math.PI;

    public static float clamp(float val, float a, float b) {
        return org.joml.Math.clamp((float)a, (float)b, (float)val);
    }

    public static double clamp(double val, double a, double b) {
        return org.joml.Math.clamp((double)a, (double)b, (double)val);
    }

    public static int clamp(int val, int a, int b) {
        return org.joml.Math.clamp((int)a, (int)b, (int)val);
    }

    public static Vector3f vec3ToVector3f(Vec3 v) {
        return new Vector3f((float)v.f_82479_, (float)v.f_82480_, (float)v.f_82481_);
    }

    public static Vec3 vector3fToVec3(Vector3f v) {
        return new Vec3((double)v.x, (double)v.y, (double)v.z);
    }

    public static float lerp(float v1, float v2, float p) {
        return v1 + (v2 - v1) * p;
    }

    public static double lerp(double v1, double v2, double p) {
        return v1 + (v2 - v1) * p;
    }

    public static Vector3f vectorBetweenVectors(Vector3f v1, Vector3f v2) {
        return v1.add((Vector3fc)v2, new Vector3f()).normalize();
    }

    public static List<Vector3f> scalePointsInDirection(List<Vector2f> basePoints, Vector2f direction, float scale) {
        float angle = org.joml.Math.atan2((float)direction.x, (float)direction.y);
        Matrix4f scale1 = new Matrix4f().scale(1.0f, scale, 1.0f);
        List<Vector3f> list = basePoints.stream().map(vec2 -> {
            Vector3f v = new Vector3f(vec2.x, vec2.y, 0.0f);
            v.rotateZ(angle);
            scale1.transformPosition(v);
            v.rotateZ(-angle);
            return v;
        }).toList();
        return list;
    }

    public static float yRotFromVector(Vec3 v) {
        if (v.f_82479_ == 0.0 && v.f_82481_ == 0.0) {
            return 0.0f;
        }
        float value = -((float)org.joml.Math.atan2((double)v.f_82479_, (double)v.f_82481_));
        return (float)org.joml.Math.toDegrees((double)value);
    }

    public static float xRotFromVector(Vec3 v) {
        Vec3 g = new Vec3(v.f_82479_, 0.0, v.f_82481_);
        float value = -((float)org.joml.Math.atan2((double)v.f_82480_, (double)g.m_82553_()));
        return (float)org.joml.Math.toDegrees((double)value);
    }

    public static float convertMCYRotationToNormal(float rot) {
        float d = rot % 360.0f;
        if (rot > 0.0f) {
            if (d > 180.0f) {
                return -180.0f + (d - 180.0f);
            }
            return d;
        }
        if (d < -180.0f) {
            return 180.0f - (-180.0f - d);
        }
        return d;
    }

    public static float lerpAround(float v1, float v2, float min, float max, float p) {
        float v2tomax;
        float v1tomin;
        float d2;
        float d1;
        if (v2 < v1) {
            float v = v2;
            v2 = v1;
            v1 = v;
            p = 1.0f - p;
        }
        if ((d1 = v2 - v1) < (d2 = (v1tomin = v1 - min) + (v2tomax = max - v2))) {
            return FDMathUtil.lerp(v1, v2, p);
        }
        float d = d2 * p;
        if (d < v1tomin) {
            return v1 - d;
        }
        float remain = d - v1tomin;
        return max - remain;
    }

    public static Vec3 projectVectorOnVector(Vec3 v, Vec3 on) {
        double dot = v.m_82526_(on);
        double v2 = on.m_82526_(on);
        double md = dot / v2;
        return on.m_82542_(md, md, md);
    }

    public static Vec3 projectVectorOntoPlane(Vec3 v, Vec3 normal) {
        Vec3 proj = FDMathUtil.projectVectorOnVector(v, normal);
        return v.m_82546_(proj);
    }

    public static double angleBetweenVectors(Vec3 v1, Vec3 v2) {
        return org.joml.Math.acos((double)(v1.m_82526_(v2) / (v1.m_82553_() * v2.m_82553_())));
    }

    public static BlockPos vec3ToBlockPos(Vec3 v) {
        return new BlockPos((int)org.joml.Math.floor((double)v.f_82479_), (int)org.joml.Math.floor((double)v.f_82480_), (int)org.joml.Math.floor((double)v.f_82481_));
    }

    public static Vec3 getNormalVectorFromLineToPoint(Vec3 begin, Vec3 end, Vec3 point) {
        Vec3 between = end.m_82546_(begin);
        Vec3 topr = point.m_82546_(begin);
        double d = topr.m_82526_(between);
        double w = between.m_82553_();
        w *= w;
        double mod = d / w;
        return point.m_82546_(begin.m_82549_(between.m_82542_(mod, mod, mod)));
    }

    public static Vector3f interpolateVectors(Vector3f v1, Vector3f v2, float p) {
        return new Vector3f(FDMathUtil.lerp(v1.x, v2.x, p), FDMathUtil.lerp(v1.y, v2.y, p), FDMathUtil.lerp(v1.z, v2.z, p));
    }

    public static Vec3 interpolateVectors(Vec3 v1, Vec3 v2, float p) {
        return new Vec3(FDMathUtil.lerp(v1.f_82479_, v2.f_82479_, (double)p), FDMathUtil.lerp(v1.f_82480_, v2.f_82480_, (double)p), FDMathUtil.lerp(v1.f_82481_, v2.f_82481_, (double)p));
    }

    public static Pair<Float, List<Float>> approximateCatmullromLength(List<Vector3f> catmullromPoints, int stepsCount) {
        float fullLength = 0.0f;
        ArrayList<Float> segmentLengths = new ArrayList<Float>();
        for (int i = 0; i < catmullromPoints.size() - 1; ++i) {
            Vector3f p1 = FDLibCalls.getListValueSafe(i - 1, catmullromPoints);
            Vector3f p2 = FDLibCalls.getListValueSafe(i, catmullromPoints);
            Vector3f p3 = FDLibCalls.getListValueSafe(i + 1, catmullromPoints);
            Vector3f p4 = FDLibCalls.getListValueSafe(i + 2, catmullromPoints);
            float step = 1.0f / (float)stepsCount;
            float l = 0.0f;
            for (float p = 0.0f; p < 1.0f; p += step) {
                Vector3f point1 = FDMathUtil.catmullrom(p1, p2, p3, p4, p);
                Vector3f point2 = FDMathUtil.catmullrom(p1, p2, p3, p4, p + step);
                Vector3f b = point2.sub((Vector3fc)point1);
                l += b.length();
            }
            segmentLengths.add(Float.valueOf(l));
            fullLength += l;
        }
        return new Pair<Float, List<Float>>(Float.valueOf(fullLength), segmentLengths);
    }

    public static Vector3f catmullRom(List<Vector3f> points, float p) {
        Pair<Float, List<Float>> lengths = FDMathUtil.approximateCatmullromLength(points, 1);
        int segmentId = 0;
        float segmentPercent = 0.0f;
        float fullLength = ((Float)lengths.first).floatValue();
        List segmentLengths = (List)lengths.second;
        float accumulatedPercent = 0.0f;
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segmentLength = ((Float)iterator.next()).floatValue();
            float lengthPercent = segmentLength / fullLength;
            if (p >= accumulatedPercent && p <= accumulatedPercent + lengthPercent) {
                float local = p - accumulatedPercent;
                segmentPercent = local / lengthPercent;
                break;
            }
            accumulatedPercent += lengthPercent;
            ++segmentId;
        }
        Vector3f p1 = FDLibCalls.getListValueSafe(segmentId - 1, points);
        Vector3f p2 = FDLibCalls.getListValueSafe(segmentId, points);
        Vector3f p3 = FDLibCalls.getListValueSafe(segmentId + 1, points);
        Vector3f p4 = FDLibCalls.getListValueSafe(segmentId + 2, points);
        return FDMathUtil.catmullrom(p1, p2, p3, p4, segmentPercent);
    }

    public static Vector3f catmullRomDerivative(List<Vector3f> points, float p) {
        Pair<Float, List<Float>> lengths = FDMathUtil.approximateCatmullromLength(points, 1);
        int segmentId = 0;
        float segmentPercent = 0.0f;
        float fullLength = ((Float)lengths.first).floatValue();
        List segmentLengths = (List)lengths.second;
        float accumulatedPercent = 0.0f;
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segmentLength = ((Float)iterator.next()).floatValue();
            float lengthPercent = segmentLength / fullLength;
            if (p >= accumulatedPercent && p <= accumulatedPercent + lengthPercent) {
                float local = p - accumulatedPercent;
                segmentPercent = local / lengthPercent;
                break;
            }
            accumulatedPercent += lengthPercent;
            ++segmentId;
        }
        Vector3f p1 = FDLibCalls.getListValueSafe(segmentId - 1, points);
        Vector3f p2 = FDLibCalls.getListValueSafe(segmentId, points);
        Vector3f p3 = FDLibCalls.getListValueSafe(segmentId + 1, points);
        Vector3f p4 = FDLibCalls.getListValueSafe(segmentId + 2, points);
        return FDMathUtil.catmullromDerivative(p1, p2, p3, p4, segmentPercent);
    }

    public static Vector3f catmullRomPrecomputedLengths(List<Vector3f> points, float p, Pair<Float, List<Float>> lengths) {
        int segmentId = 0;
        float segmentPercent = 0.0f;
        float fullLength = ((Float)lengths.first).floatValue();
        List segmentLengths = (List)lengths.second;
        float accumulatedPercent = 0.0f;
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segmentLength = ((Float)iterator.next()).floatValue();
            float lengthPercent = segmentLength / fullLength;
            if (p >= accumulatedPercent && p <= accumulatedPercent + lengthPercent) {
                float local = p - accumulatedPercent;
                segmentPercent = local / lengthPercent;
                break;
            }
            accumulatedPercent += lengthPercent;
            ++segmentId;
        }
        Vector3f p1 = FDLibCalls.getListValueSafe(segmentId - 1, points);
        Vector3f p2 = FDLibCalls.getListValueSafe(segmentId, points);
        Vector3f p3 = FDLibCalls.getListValueSafe(segmentId + 1, points);
        Vector3f p4 = FDLibCalls.getListValueSafe(segmentId + 2, points);
        return FDMathUtil.catmullrom(p1, p2, p3, p4, segmentPercent);
    }

    public static Vector3f catmullRomDerivativePrecomputedLengths(List<Vector3f> points, float p, Pair<Float, List<Float>> lengths) {
        int segmentId = 0;
        float segmentPercent = 0.0f;
        float fullLength = ((Float)lengths.first).floatValue();
        List segmentLengths = (List)lengths.second;
        float accumulatedPercent = 0.0f;
        Iterator iterator = segmentLengths.iterator();
        while (iterator.hasNext()) {
            float segmentLength = ((Float)iterator.next()).floatValue();
            float lengthPercent = segmentLength / fullLength;
            if (p >= accumulatedPercent && p <= accumulatedPercent + lengthPercent) {
                float local = p - accumulatedPercent;
                segmentPercent = local / lengthPercent;
                break;
            }
            accumulatedPercent += lengthPercent;
            ++segmentId;
        }
        Vector3f p1 = FDLibCalls.getListValueSafe(segmentId - 1, points);
        Vector3f p2 = FDLibCalls.getListValueSafe(segmentId, points);
        Vector3f p3 = FDLibCalls.getListValueSafe(segmentId + 1, points);
        Vector3f p4 = FDLibCalls.getListValueSafe(segmentId + 2, points);
        return FDMathUtil.catmullromDerivative(p1, p2, p3, p4, segmentPercent);
    }

    public static Vec3 linear(List<Vec3> points, float p) {
        if (p < 0.0f) {
            return points.get(0);
        }
        if (p >= 1.0f) {
            return points.get(points.size() - 1);
        }
        float glP = p * (float)(points.size() - 1);
        int id1 = (int)glP;
        float lp = glP - (float)id1;
        Vec3 cur = points.get(id1);
        Vec3 next = points.get(id1 + 1);
        return FDMathUtil.interpolateVectors(cur, next, lp);
    }

    public static float catmullrom(Float previous, Float current, Float next, Float next2, float p) {
        if (next == null) {
            return current.floatValue();
        }
        if (previous == null) {
            previous = Float.valueOf(current.floatValue() + (current.floatValue() - next.floatValue()));
        }
        if (next2 == null) {
            next2 = Float.valueOf(next.floatValue() + (next.floatValue() - current.floatValue()));
        }
        float xvc = (next.floatValue() - previous.floatValue()) / 6.0f;
        float xvn = (current.floatValue() - next2.floatValue()) / 6.0f;
        return FDMathUtil.bernstein(current.floatValue(), current.floatValue() + xvc, next.floatValue() + xvn, next.floatValue(), p);
    }

    public static float catmullromDerivative(Float previous, Float current, Float next, Float next2, float p) {
        if (next == null) {
            return current.floatValue();
        }
        if (previous == null) {
            previous = Float.valueOf(current.floatValue() + (current.floatValue() - next.floatValue()));
        }
        if (next2 == null) {
            next2 = Float.valueOf(next.floatValue() + (next.floatValue() - current.floatValue()));
        }
        float xvc = (next.floatValue() - previous.floatValue()) / 6.0f;
        float xvn = (current.floatValue() - next2.floatValue()) / 6.0f;
        return FDMathUtil.bernsteinDerivative(current.floatValue(), current.floatValue() + xvc, next.floatValue() + xvn, next.floatValue(), p);
    }

    public static double catmullrom(Double previous, Double current, Double next, Double next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current + (current - next);
        }
        if (next2 == null) {
            next2 = next + (next - current);
        }
        double xvc = (next - previous) / 6.0;
        double xvn = (current - next2) / 6.0;
        return FDMathUtil.bernstein(current, current + xvc, next + xvn, next, (double)p);
    }

    public static double catmullromDerivative(Double previous, Double current, Double next, Double next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current + (current - next);
        }
        if (next2 == null) {
            next2 = next + (next - current);
        }
        double xvc = (next - previous) / 6.0;
        double xvn = (current - next2) / 6.0;
        return FDMathUtil.bernsteinDerivative(current, current + xvc, next + xvn, next, (double)p);
    }

    public static Vector3f catmullrom(Vector3f previous, Vector3f current, Vector3f next, Vector3f next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.add((Vector3fc)current.sub((Vector3fc)next, new Vector3f()), new Vector3f());
        }
        if (next2 == null) {
            next2 = next.add((Vector3fc)next.sub((Vector3fc)current, new Vector3f()), new Vector3f());
        }
        return new Vector3f(FDMathUtil.catmullrom(Float.valueOf(previous.x), Float.valueOf(current.x), Float.valueOf(next.x), Float.valueOf(next2.x), p), FDMathUtil.catmullrom(Float.valueOf(previous.y), Float.valueOf(current.y), Float.valueOf(next.y), Float.valueOf(next2.y), p), FDMathUtil.catmullrom(Float.valueOf(previous.z), Float.valueOf(current.z), Float.valueOf(next.z), Float.valueOf(next2.z), p));
    }

    public static Vector3f catmullromDerivative(Vector3f previous, Vector3f current, Vector3f next, Vector3f next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.add((Vector3fc)current.sub((Vector3fc)next, new Vector3f()), new Vector3f());
        }
        if (next2 == null) {
            next2 = next.add((Vector3fc)next.sub((Vector3fc)current, new Vector3f()), new Vector3f());
        }
        return new Vector3f(FDMathUtil.catmullromDerivative(Float.valueOf(previous.x), Float.valueOf(current.x), Float.valueOf(next.x), Float.valueOf(next2.x), p), FDMathUtil.catmullromDerivative(Float.valueOf(previous.y), Float.valueOf(current.y), Float.valueOf(next.y), Float.valueOf(next2.y), p), FDMathUtil.catmullromDerivative(Float.valueOf(previous.z), Float.valueOf(current.z), Float.valueOf(next.z), Float.valueOf(next2.z), p));
    }

    public static Vec3 catmullrom(Vec3 previous, Vec3 current, Vec3 next, Vec3 next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.m_82549_(current.m_82546_(next));
        }
        if (next2 == null) {
            next2 = next.m_82549_(next.m_82546_(current));
        }
        return new Vec3(FDMathUtil.catmullrom(previous.f_82479_, current.f_82479_, next.f_82479_, next2.f_82479_, p), FDMathUtil.catmullrom(previous.f_82480_, current.f_82480_, next.f_82480_, next2.f_82480_, p), FDMathUtil.catmullrom(previous.f_82481_, current.f_82481_, next.f_82481_, next2.f_82481_, p));
    }

    public static Vec3 catmullromDerivative(Vec3 previous, Vec3 current, Vec3 next, Vec3 next2, float p) {
        if (next == null) {
            return current;
        }
        if (previous == null) {
            previous = current.m_82549_(current.m_82546_(next));
        }
        if (next2 == null) {
            next2 = next.m_82549_(next.m_82546_(current));
        }
        return new Vec3(FDMathUtil.catmullromDerivative(previous.f_82479_, current.f_82479_, next.f_82479_, next2.f_82479_, p), FDMathUtil.catmullromDerivative(previous.f_82480_, current.f_82480_, next.f_82480_, next2.f_82480_, p), FDMathUtil.catmullromDerivative(previous.f_82481_, current.f_82481_, next.f_82481_, next2.f_82481_, p));
    }

    public static float bernstein(float x1, float x2, float x3, float x4, float t) {
        float t3 = (float)Math.pow(t, 3.0);
        float t2 = (float)Math.pow(t, 2.0);
        return x1 * (-t3 + 3.0f * t2 - 3.0f * t + 1.0f) + x2 * (3.0f * t3 - 6.0f * t2 + 3.0f * t) + x3 * (-3.0f * t3 + 3.0f * t2) + x4 * t3;
    }

    public static float bernsteinDerivative(float x1, float x2, float x3, float x4, float t) {
        float t2 = (float)Math.pow(t, 2.0);
        return x1 * (-3.0f * t2 + 6.0f * t - 3.0f) + x2 * (9.0f * t2 - 12.0f * t + 3.0f) + x3 * (-9.0f * t2 + 6.0f * t) + x4 * 3.0f * t2;
    }

    public static double bernstein(double x1, double x2, double x3, double x4, double t) {
        double t3 = Math.pow(t, 3.0);
        double t2 = Math.pow(t, 2.0);
        return x1 * (-t3 + 3.0 * t2 - 3.0 * t + 1.0) + x2 * (3.0 * t3 - 6.0 * t2 + 3.0 * t) + x3 * (-3.0 * t3 + 3.0 * t2) + x4 * t3;
    }

    public static double bernsteinDerivative(double x1, double x2, double x3, double x4, double t) {
        float t2 = (float)Math.pow(t, 2.0);
        return x1 * ((double)(-3.0f * t2) + 6.0 * t - 3.0) + x2 * ((double)(9.0f * t2) - 12.0 * t + 3.0) + x3 * ((double)(-9.0f * t2) + 6.0 * t) + x4 * 3.0 * (double)t2;
    }

    public static float normalDistribution(float x, float m, float o) {
        float fc = 1.0f / org.joml.Math.sqrt((float)(o * o * (float)Math.PI * 2.0f));
        float st = (float)Math.pow(x - m, 2.0) / (2.0f * o * o);
        float mt = (float)org.joml.Math.exp((double)(-st));
        return fc * mt;
    }
}

