/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.particle.particle_emitter;

import com.finderfeed.fdlib.systems.particle.particle_emitter.EmitterProcessor;
import com.finderfeed.fdlib.systems.particle.particle_emitter.EmptyEmitterProcessor;
import com.finderfeed.fdlib.systems.stream_codecs.NetworkCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ParticleEmitterData {
    public static final NetworkCodec<List<ParticleOptions>> OPTIONS_CODEC = new NetworkCodec<List<ParticleOptions>>(){

        @Override
        public List<ParticleOptions> fromNetwork(FriendlyByteBuf buf) {
            ArrayList<ParticleOptions> list = new ArrayList<ParticleOptions>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                ResourceLocation location = buf.m_130281_();
                ParticleType type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(location);
                if (type == null) {
                    throw new RuntimeException("Unknown particle type: " + location);
                }
                ParticleOptions.Deserializer deserializer = type.m_123743_();
                ParticleOptions options = ParticleEmitterData.deserializeParticle(buf, type, deserializer);
                list.add(options);
            }
            return list;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, List<ParticleOptions> list) {
            buf.writeInt(list.size());
            for (ParticleOptions options : list) {
                ParticleType type = options.m_6012_();
                ResourceLocation key = ForgeRegistries.PARTICLE_TYPES.getKey((Object)type);
                buf.m_130085_(key);
                options.m_7711_(buf);
            }
        }
    };
    public static final NetworkCodec<ParticleEmitterData> STREAM_CODEC = NetworkCodec.composite(NetworkCodec.VEC3, v -> v.position, NetworkCodec.INT, v -> v.lifetime, NetworkCodec.INT, v -> v.particlesPerTick, EmitterProcessor.STREAM_CODEC, v -> v.processor, OPTIONS_CODEC, v -> v.particleTypes, (position, lifetime, particlesPerTick, processor, types) -> {
        ParticleEmitterData data = new ParticleEmitterData();
        data.position = position;
        data.lifetime = lifetime;
        data.processor = processor;
        data.particleTypes = types;
        data.particlesPerTick = particlesPerTick;
        return data;
    });
    public Vec3 position = Vec3.f_82478_;
    public int particlesPerTick = 1;
    public int lifetime = 20;
    public EmitterProcessor<?> processor = new EmptyEmitterProcessor();
    public List<ParticleOptions> particleTypes = new ArrayList<ParticleOptions>();

    private static <T extends ParticleOptions> ParticleOptions deserializeParticle(FriendlyByteBuf buf, ParticleType<?> particleType, ParticleOptions.Deserializer<T> deserializer) {
        return deserializer.m_6507_(particleType, buf);
    }

    private ParticleEmitterData() {
    }

    public static Builder builder(ParticleOptions options) {
        return new Builder(options);
    }

    public static class Builder {
        private ParticleEmitterData data = new ParticleEmitterData();

        public Builder(ParticleOptions options) {
            this.data.particleTypes.add(options);
        }

        public Builder position(Vec3 v) {
            this.data.position = v;
            return this;
        }

        public Builder lifetime(int lifetime) {
            this.data.lifetime = lifetime;
            return this;
        }

        public Builder processor(EmitterProcessor<?> processor) {
            this.data.processor = processor;
            return this;
        }

        public Builder particlesPerTick(int amount) {
            this.data.particlesPerTick = amount;
            return this;
        }

        public Builder addParticle(ParticleOptions options) {
            this.data.particleTypes.add(options);
            return this;
        }

        public ParticleEmitterData build() {
            return this.data;
        }
    }
}

