/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.fdlib.systems.music.music_areas;

import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.music.data.FDMusicData;
import com.finderfeed.fdlib.systems.music.music_areas.shapes.FDMusicAreaShape;
import com.finderfeed.fdlib.systems.music.packets.FDMusicAreaEnterPacket;
import com.finderfeed.fdlib.systems.music.packets.FDMusicEndPacket;
import com.finderfeed.fdlib.systems.music.packets.FDMusicFadeOutPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;

public class FDMusicArea {
    private List<UUID> playersInside = new ArrayList<UUID>();
    protected UUID uuid;
    private Vec3 position;
    private ResourceKey<Level> dimension;
    private FDMusicAreaShape shape;
    private FDMusicData musicData;
    private int autoDeletionTicker;
    private int maxDeletionTicker = this.autoDeletionTicker = 2400;
    private int playerDetectionFrequency = 5;

    public FDMusicArea(ResourceKey<Level> dimension, Vec3 position, FDMusicAreaShape shape, FDMusicData musicData) {
        this.dimension = dimension;
        this.position = position;
        this.shape = shape;
        this.musicData = musicData;
    }

    public void tick(ServerLevel level) {
        if (level.m_46467_() % (long)this.playerDetectionFrequency == 0L) {
            List<ServerPlayer> playersInside = this.shape.getPlayersInside(level, this.position);
            List<UUID> uuidsInside = playersInside.stream().map(Entity::m_20148_).toList();
            for (ServerPlayer serverPlayer : playersInside) {
                UUID uuid = serverPlayer.m_20148_();
                if (this.playersInside.contains(uuid)) continue;
                FDPacketHandler.INSTANCE.sendTo((Object)new FDMusicAreaEnterPacket(this.musicData, 20), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                this.playersInside.add(uuid);
            }
            ArrayList<UUID> playersThatExitedTheArea = new ArrayList<UUID>(this.playersInside);
            playersThatExitedTheArea.removeAll(uuidsInside);
            this.playersInside.removeAll(playersThatExitedTheArea);
            for (UUID uuid : playersThatExitedTheArea) {
                ServerPlayer serverPlayer = level.m_7654_().m_6846_().m_11259_(uuid);
                if (serverPlayer == null) continue;
                FDPacketHandler.INSTANCE.sendTo((Object)new FDMusicFadeOutPacket(this.musicData.getMusicSourceUUID(), 20), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void onRemoval(MinecraftServer server, int fadeOutTime) {
        for (UUID player : this.playersInside) {
            ServerPlayer actualPlayer = server.m_6846_().m_11259_(player);
            if (actualPlayer == null) continue;
            FDPacketHandler.INSTANCE.sendTo((Object)new FDMusicEndPacket(this.musicData.getMusicSourceUUID(), fadeOutTime), actualPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    protected void tickDeletionTicker(boolean ignorePlayersInside) {
        this.autoDeletionTicker = this.playersInside.isEmpty() || ignorePlayersInside ? --this.autoDeletionTicker : this.maxDeletionTicker;
    }

    public void setAutoDeletionTicker(int autoDeletionTicker) {
        this.autoDeletionTicker = autoDeletionTicker;
        this.maxDeletionTicker = autoDeletionTicker;
    }

    public boolean shouldBeDeleted() {
        return this.autoDeletionTicker < 0;
    }

    public void setPlayerDetectionFrequency(int playerDetectionFrequency) {
        this.playerDetectionFrequency = playerDetectionFrequency;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public FDMusicAreaShape getShape() {
        return this.shape;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public FDMusicData getMusicData() {
        return this.musicData;
    }

    public void setMusicData(FDMusicData musicData) {
        this.musicData = musicData;
    }
}

