/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.radiantgear;

import com.illusivesoulworks.radiantgear.integration.arsnouveau.ArsNouveauModule;
import com.illusivesoulworks.radiantgear.integration.dynamiclights.DynamicLightsModule;
import com.illusivesoulworks.radiantgear.integration.dynamiclightsreforged.DLReforgedModule;
import com.illusivesoulworks.radiantgear.integration.embeddiumplus.EmbeddiumPlusModule;
import com.illusivesoulworks.radiantgear.integration.ryoamiclights.RyoamicModule;
import com.illusivesoulworks.radiantgear.integration.sodiumdynamiclights.SDLModule;
import java.util.Objects;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

@Mod(value="radiantgear")
public class RadiantGearForgeMod {
    private static boolean isAtomicDLLoaded = false;
    private static boolean isDLReforgedLoaded = false;
    private static boolean isArsNouveauLoaded = false;
    private static boolean isRyoamicLoaded = false;
    private static boolean isEmbeddiumPlusLoaded = false;
    private static boolean isSDLLoaded = false;

    public RadiantGearForgeMod() {
        Object maxVersion;
        ModList modList = ModList.get();
        isDLReforgedLoaded = modList.isLoaded("dynamiclightsreforged");
        isArsNouveauLoaded = modList.isLoaded("ars_nouveau");
        isRyoamicLoaded = modList.isLoaded("ryoamiclights");
        isSDLLoaded = modList.isLoaded("sodiumdynamiclights");
        if (modList.isLoaded("embeddiumplus")) {
            maxVersion = new DefaultArtifactVersion("1.2.4");
            DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(modList.getModFileById("embeddiumplus").versionString());
            boolean bl = isEmbeddiumPlusLoaded = currentVersion.compareTo((ArtifactVersion)maxVersion) < 0;
        }
        if (modList.isLoaded("dynamiclights") && (maxVersion = modList.getModFileById("dynamiclights").getFile().getModFileInfo().getMods().iterator()).hasNext()) {
            IModInfo mod = (IModInfo)maxVersion.next();
            mod.getConfig().getConfigElement(new String[]{"authors"}).ifPresent(element -> {
                if (element.equals("AtomicStryker")) {
                    isAtomicDLLoaded = true;
                }
            });
        }
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        ModLoadingContext context = ModLoadingContext.get();
        context.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> this.getRemoteVersion(context), (incoming, isNetwork) -> this.acceptsServer(context, (String)incoming)));
    }

    private void setup(FMLCommonSetupEvent evt) {
        if (isAtomicDLLoaded) {
            DynamicLightsModule.setup();
        }
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        if (isDLReforgedLoaded) {
            DLReforgedModule.setup();
        }
        if (isRyoamicLoaded) {
            RyoamicModule.setup();
        }
        if (isEmbeddiumPlusLoaded) {
            EmbeddiumPlusModule.setup();
        }
        if (isArsNouveauLoaded) {
            ArsNouveauModule.setup();
        }
        if (isSDLLoaded) {
            SDLModule.setup();
        }
    }

    private String getRemoteVersion(ModLoadingContext context) {
        if (isAtomicDLLoaded) {
            return context.getActiveContainer().getModInfo().getVersion().toString();
        }
        return "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31";
    }

    private boolean acceptsServer(ModLoadingContext context, String incoming) {
        if (isAtomicDLLoaded) {
            return Objects.equals(incoming, context.getActiveContainer().getModInfo().getVersion().toString());
        }
        return true;
    }
}

