/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.icon;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.icon.DynamicIconRegistry;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public final class DynamicIconForgeSubscriber {
    private DynamicIconForgeSubscriber() {
    }

    public static void onClientSetup() {
        for (IModInfo info : ModList.get().getMods()) {
            String modId = info.getModId();
            Optional<String> selected = DynamicIconRegistry.getSelectedForgePath(modId);
            if (selected.isEmpty()) continue;
            try {
                Field field = DynamicIconForgeSubscriber.findLogoField(info);
                if (field == null) continue;
                field.setAccessible(true);
                field.set(info, selected);
                OELib.LOGGER.info("[OELib: DynamicIcon] Set icon for {}: {}", (Object)modId, (Object)selected.get());
            }
            catch (Throwable throwable) {}
        }
    }

    private static Field findLogoField(IModInfo info) {
        try {
            Field f = info.getClass().getDeclaredField("logoFile");
            if (Optional.class.isAssignableFrom(f.getType())) {
                return f;
            }
        }
        catch (NoSuchFieldException f) {
            // empty catch block
        }
        String current = info.getLogoFile().orElse(null);
        for (Field f : info.getClass().getDeclaredFields()) {
            if (!Optional.class.isAssignableFrom(f.getType())) continue;
            try {
                String s;
                Optional opt;
                Object ov;
                f.setAccessible(true);
                Object v = f.get(info);
                if (!(v instanceof Optional) || !((ov = (opt = (Optional)v).orElse(null)) instanceof String) || !Objects.equals(s = (String)ov, current)) continue;
                return f;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }
}

