/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data.net;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.api.net.INetworkContext;
import com.mafuyu404.oelib.api.net.INetworkPacket;
import com.mafuyu404.oelib.api.net.NetworkPacket;
import com.mafuyu404.oelib.forge.network.ChunkAssembler;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;

@NetworkPacket(priority=0)
public record DataSyncChunkPacket(UUID sessionId, int chunkIndex, int totalChunks, String dataClassName, byte[] chunkData) implements INetworkPacket<DataSyncChunkPacket>
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.sessionId);
        buf.writeInt(this.chunkIndex);
        buf.writeInt(this.totalChunks);
        buf.m_130070_(this.dataClassName);
        buf.writeInt(this.chunkData.length);
        buf.writeBytes(this.chunkData);
    }

    public static DataSyncChunkPacket decode(FriendlyByteBuf buf) {
        UUID sessionId = buf.m_130259_();
        int chunkIndex = buf.readInt();
        int totalChunks = buf.readInt();
        String dataClassName = buf.m_130277_();
        int dataLength = buf.readInt();
        byte[] chunkData = new byte[dataLength];
        buf.readBytes(chunkData);
        return new DataSyncChunkPacket(sessionId, chunkIndex, totalChunks, dataClassName, chunkData);
    }

    @Override
    public void handle(INetworkContext context) {
        try {
            ChunkAssembler.receiveChunk(this.sessionId, this.chunkIndex, this.totalChunks, this.dataClassName, this.chunkData);
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to handle chunk packet: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

