/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.data.mvel;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.data.mvel.gen.ExpressionFunctionRegistry;
import com.mafuyu404.oelib.data.mvel.gen.ExpressionFunctionsRegistrar;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public final class ExpressionEngine {
    private static final Map<String, Method> functionMap = new ConcurrentHashMap<String, Method>();
    private static final Map<String, Serializable> compiledExpressions = new ConcurrentHashMap<String, Serializable>();
    private static ParserContext parserContext = new ParserContext();
    private static boolean initialized = false;

    private ExpressionEngine() {
    }

    public static void initialize() {
        ExpressionEngine.initialize(null);
    }

    public static void initialize(Set<String> requiredFunctions) {
        functionMap.clear();
        compiledExpressions.clear();
        parserContext = new ParserContext();
        ServiceLoader<ExpressionFunctionsRegistrar> loader = ServiceLoader.load(ExpressionFunctionsRegistrar.class);
        ExpressionFunctionRegistry registry = (name, ownerClass, methodName, parameterTypes) -> {
            if (requiredFunctions != null && !requiredFunctions.contains(name)) {
                return;
            }
            try {
                Method method = ownerClass.getDeclaredMethod(methodName, parameterTypes);
                functionMap.put(name, method);
                parserContext.addImport(name, method);
                OELib.LOGGER.debug("Registered function: {} ({}#{})", new Object[]{name, ownerClass.getSimpleName(), methodName});
            }
            catch (Exception e) {
                OELib.LOGGER.warn("Failed to register function {} ({}#{}): {}", new Object[]{name, ownerClass.getName(), methodName, e.getMessage()});
            }
        };
        int registrarCount = 0;
        for (ExpressionFunctionsRegistrar registrar : loader) {
            ++registrarCount;
            registrar.register(registry, requiredFunctions);
        }
        if (requiredFunctions != null && functionMap.isEmpty()) {
            OELib.LOGGER.warn("No functions registered for required set {}. Falling back to full registration.", requiredFunctions);
            ExpressionEngine.initialize(null);
            return;
        }
        initialized = true;
        OELib.LOGGER.info("Expression engine initialized via generated registrars: {} registrars, {} functions", (Object)registrarCount, (Object)functionMap.size());
    }

    public static Object evaluate(String expression, Map<String, Object> context) {
        return ExpressionEngine.evaluate(expression, context, true);
    }

    public static Object evaluate(String expression, Map<String, Object> context, boolean logErrors) {
        try {
            if (!initialized) {
                ExpressionEngine.initialize();
            }
            Serializable compiled = compiledExpressions.computeIfAbsent(expression, expr -> MVEL.compileExpression((String)expr, (ParserContext)parserContext));
            return MVEL.executeExpression((Object)compiled, (Map)(context != null ? context : new HashMap()));
        }
        catch (Exception e) {
            if (logErrors) {
                OELib.LOGGER.error("Failed to evaluate expression: {}", (Object)expression, (Object)e);
            }
            throw e;
        }
    }

    public static boolean isValidExpression(String expression) {
        try {
            ExpressionEngine.evaluate(expression, new HashMap<String, Object>(), false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Map<String, Method> getAllFunctions() {
        return new HashMap<String, Method>(functionMap);
    }

    public static void clear() {
        functionMap.clear();
        compiledExpressions.clear();
        initialized = false;
    }

    public static void hotReload() {
        ExpressionEngine.clear();
        ExpressionEngine.initialize();
        OELib.LOGGER.debug("Expression engine hot reload completed");
    }

    public static Map<String, Object> createContext(Map<String, String> vars) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (vars != null) {
            for (Map.Entry<String, String> var : vars.entrySet()) {
                try {
                    Object value = ExpressionEngine.evaluate(var.getValue(), context, false);
                    context.put(var.getKey(), value);
                }
                catch (Exception e) {
                    OELib.LOGGER.debug("Failed to evaluate variable {}: {}", (Object)var.getKey(), (Object)e.getMessage());
                    context.put(var.getKey(), var.getValue());
                }
            }
        }
        return context;
    }

    public static boolean checkConditions(Map<String, String> conditions, Map<String, Object> context) {
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> condition : conditions.entrySet()) {
            String expectedStr;
            Object expectedValue;
            String key = condition.getKey();
            String expression = condition.getValue();
            Object actualValue = context.get(key);
            try {
                expectedValue = ExpressionEngine.evaluate(expression, context, false);
            }
            catch (Exception e) {
                expectedValue = expression;
            }
            if (expectedValue instanceof String && (expectedStr = (String)expectedValue).contains("*")) {
                String pattern = expectedStr.replace("*", ".*");
                if (actualValue != null && Objects.equals(true, actualValue.toString().matches(pattern))) continue;
                return false;
            }
            if (Objects.equals(expectedValue, actualValue)) continue;
            return false;
        }
        return true;
    }

    public static void executeActions(List<String> actions, Map<String, Object> context) {
        if (actions == null) {
            return;
        }
        for (String action : actions) {
            try {
                ExpressionEngine.evaluate(action, context);
            }
            catch (Exception e) {
                OELib.LOGGER.error("Failed to execute action: {}", (Object)action, (Object)e);
            }
        }
    }

    public static boolean checkModLoadedCondition(Map<String, String> vars) {
        if (vars == null || !vars.containsKey("modLoaded")) {
            return true;
        }
        try {
            HashMap<String, Object> tempContext = new HashMap<String, Object>();
            Object result = ExpressionEngine.evaluate(vars.get("modLoaded"), tempContext, false);
            return !Boolean.FALSE.equals(result);
        }
        catch (Exception e) {
            OELib.LOGGER.debug("Failed to evaluate modLoaded condition: {}", (Object)e.getMessage());
            return true;
        }
    }
}

