/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.cataclysm_dimension;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CataclysmDimensionModConfig {
    public static boolean ENABLE_TELEPORT_EYE = true;
    public static boolean KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS = false;
    public static boolean RANDOM_SPREAD_IN_DIMENSION = false;
    public static boolean RESET_DIMENSION_IF_NO_PLAYER = false;
    public static boolean SLOW_FALL_WHEN_ENTER_DIMENSIONS = true;
    public static boolean DISABLE_RESPAWN = false;
    private static final String ENABLE_TELEPORT_EYE_KEY = "enable_teleport_eye";
    private static final String KEEP_STRUCTURES_KEY = "keep_structures_in_original_dimensions";
    private static final String RANDOM_SPREAD_KEY = "random_spread_in_dimension";
    private static final String RESET_DIMENSION_KEY = "reset_dimension_if_no_player";
    private static final String SLOW_FALL_WHEN_ENTER_DIMENSIONS_KEY = "slow_fall_when_enter_dimensions";
    private static final String DISABLE_RESPAWN_KEY = "disable_respawn";
    public static final String JSON = "cataclysm_dimension.json";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cataclysm_dimension_config");
    private static final Map<String, Object> DEFAULT_CONFIG = Map.of("enable_teleport_eye", ENABLE_TELEPORT_EYE, "keep_structures_in_original_dimensions", KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS, "random_spread_in_dimension", RANDOM_SPREAD_IN_DIMENSION, "reset_dimension_if_no_player", RESET_DIMENSION_IF_NO_PLAYER, "slow_fall_when_enter_dimensions", SLOW_FALL_WHEN_ENTER_DIMENSIONS, "disable_respawn", DISABLE_RESPAWN);

    public static void loadConfig() {
        File configFolder = new File("config", "cataclysm_dimension");
        File configFile = new File(configFolder, JSON);
        if (!configFolder.exists() && !configFolder.mkdirs()) {
            LOGGER.error("Failed to create config folder: {}", (Object)configFolder.getAbsolutePath());
            return;
        }
        if (!configFile.exists()) {
            CataclysmDimensionModConfig.generateConfig(configFile);
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject config = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            boolean needsUpdate = false;
            for (Map.Entry<String, Object> entry : DEFAULT_CONFIG.entrySet()) {
                String key = entry.getKey();
                if (config.has(key)) continue;
                LOGGER.info("Adding missing config key: {}", (Object)key);
                if (entry.getValue() instanceof Boolean) {
                    config.addProperty(key, (Boolean)entry.getValue());
                }
                needsUpdate = true;
            }
            if (needsUpdate) {
                try (FileWriter writer = new FileWriter(configFile);){
                    writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)config));
                }
            }
            ENABLE_TELEPORT_EYE = config.get(ENABLE_TELEPORT_EYE_KEY).getAsBoolean();
            RANDOM_SPREAD_IN_DIMENSION = config.get(RANDOM_SPREAD_KEY).getAsBoolean();
            KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS = config.get(KEEP_STRUCTURES_KEY).getAsBoolean();
            RESET_DIMENSION_IF_NO_PLAYER = config.get(RESET_DIMENSION_KEY).getAsBoolean();
            SLOW_FALL_WHEN_ENTER_DIMENSIONS = config.get(SLOW_FALL_WHEN_ENTER_DIMENSIONS_KEY).getAsBoolean();
            DISABLE_RESPAWN = config.get(DISABLE_RESPAWN_KEY).getAsBoolean();
        }
        catch (IOException e) {
            LOGGER.error("Failed to load configuration file: {}", (Object)e.getMessage());
            CataclysmDimensionModConfig.useDefaultValues();
        }
        catch (Exception e) {
            LOGGER.error("Error parsing configuration file: {}", (Object)e.getMessage());
            CataclysmDimensionModConfig.generateConfig(configFile);
            CataclysmDimensionModConfig.useDefaultValues();
        }
    }

    private static void generateConfig(File configFile) {
        block9: {
            try {
                if (configFile.createNewFile()) {
                    LOGGER.info("Generating configuration file: {}", (Object)configFile.getAbsolutePath());
                    JsonObject config = new JsonObject();
                    for (Map.Entry<String, Object> entry : DEFAULT_CONFIG.entrySet()) {
                        if (!(entry.getValue() instanceof Boolean)) continue;
                        config.addProperty(entry.getKey(), (Boolean)entry.getValue());
                    }
                    try (FileWriter writer = new FileWriter(configFile);){
                        writer.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)config));
                        break block9;
                    }
                }
                LOGGER.error("Failed to create configuration file: {}", (Object)configFile.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Error generating configuration file: {}", (Object)e.getMessage());
            }
        }
    }

    private static void useDefaultValues() {
        ENABLE_TELEPORT_EYE = (Boolean)DEFAULT_CONFIG.get(ENABLE_TELEPORT_EYE_KEY);
        RANDOM_SPREAD_IN_DIMENSION = (Boolean)DEFAULT_CONFIG.get(RANDOM_SPREAD_KEY);
        KEEP_STRUCTURES_IN_ORIGINAL_DIMENSIONS = (Boolean)DEFAULT_CONFIG.get(KEEP_STRUCTURES_KEY);
        RESET_DIMENSION_IF_NO_PLAYER = (Boolean)DEFAULT_CONFIG.get(RESET_DIMENSION_KEY);
        SLOW_FALL_WHEN_ENTER_DIMENSIONS = (Boolean)DEFAULT_CONFIG.get(SLOW_FALL_WHEN_ENTER_DIMENSIONS_KEY);
        DISABLE_RESPAWN = (Boolean)DEFAULT_CONFIG.get(DISABLE_RESPAWN_KEY);
    }
}

