/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.JsonConfig;

public class ThemeHelper
extends SimpleJsonResourceReloadListener
implements IThemeHelper {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    public static final ResourceLocation ID = new ResourceLocation("jade", "themes");
    private static final Int2ObjectMap<Style> styleCache = new Int2ObjectOpenHashMap(6);
    private final Map<ResourceLocation, Theme> themes = Maps.newTreeMap(Comparator.comparing(ResourceLocation::toString));

    public ThemeHelper() {
        super(JsonConfig.GSON, "jade_themes");
    }

    public static Style colorStyle(int color) {
        return (Style)styleCache.computeIfAbsent(color, arg_0 -> ((Style)Style.f_131099_).m_178520_(arg_0));
    }

    @Override
    public Theme theme() {
        return (Theme)OverlayRenderer.theme.getValue();
    }

    @Override
    public Collection<Theme> getThemes() {
        return this.themes.values();
    }

    @Override
    @NotNull
    public Theme getTheme(ResourceLocation id) {
        return this.themes.getOrDefault(id, Theme.DARK);
    }

    @Override
    public MutableComponent info(Object componentOrString) {
        return this.color(componentOrString, this.theme().infoColor);
    }

    @Override
    public MutableComponent success(Object componentOrString) {
        return this.color(componentOrString, this.theme().successColor);
    }

    @Override
    public MutableComponent warning(Object componentOrString) {
        return this.color(componentOrString, this.theme().warningColor);
    }

    @Override
    public MutableComponent danger(Object componentOrString) {
        return this.color(componentOrString, this.theme().dangerColor);
    }

    @Override
    public MutableComponent failure(Object componentOrString) {
        return this.color(componentOrString, this.theme().failureColor);
    }

    @Override
    public MutableComponent title(Object componentOrString) {
        MutableComponent component = componentOrString instanceof MutableComponent ? (MutableComponent)componentOrString : Component.m_237113_((String)Objects.toString(componentOrString));
        return this.color(DisplayHelper.INSTANCE.stripColor((Component)component), this.theme().titleColor);
    }

    @Override
    public MutableComponent seconds(int ticks) {
        return this.info(JadeClient.format("jade.seconds", ticks / 20));
    }

    protected MutableComponent color(Object componentOrString, int color) {
        if (componentOrString instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)componentOrString;
            if (component.m_7383_().m_131179_()) {
                return component.m_6270_(ThemeHelper.colorStyle(color));
            }
            return component.m_6270_(component.m_7383_().m_178520_(color));
        }
        return Component.m_237113_((String)Objects.toString(componentOrString)).m_6270_(ThemeHelper.colorStyle(color));
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        Set<ResourceLocation> existingKeys = Set.copyOf(this.themes.keySet());
        MutableObject enable = new MutableObject();
        WailaConfig.ConfigOverlay config = Jade.CONFIG.get().getOverlay();
        this.themes.clear();
        map.forEach((id, json) -> {
            try {
                JsonObject o = json.getAsJsonObject();
                Theme theme = (Theme)JsonConfig.GSON.fromJson((JsonElement)o, Theme.class);
                theme.id = id;
                this.themes.put((ResourceLocation)id, theme);
                if (enable.getValue() == null && GsonHelper.m_13855_((JsonObject)o, (String)"autoEnable", (boolean)false) && !existingKeys.contains(id)) {
                    enable.setValue((Object)theme);
                }
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to load theme {}", id, (Object)e);
            }
        });
        int hash = 0;
        for (ResourceLocation id2 : this.themes.keySet()) {
            hash = 31 * hash + id2.hashCode();
        }
        if (hash != config.themesHash) {
            if (hash != 0 && enable.getValue() != null) {
                Theme theme = (Theme)enable.getValue();
                config.activeTheme = theme.id;
                Jade.LOGGER.info("Auto enabled theme {}", (Object)theme.id);
                if (theme.squareBorder != null) {
                    config.setSquare(theme.squareBorder);
                }
                if (theme.opacity != 0.0f) {
                    config.setAlpha(theme.opacity);
                }
            }
            config.themesHash = hash;
            Jade.CONFIG.save();
        }
        if (this.themes.isEmpty()) {
            this.themes.put(Theme.DARK.id, Theme.DARK);
        }
        config.applyTheme(config.activeTheme);
    }
}

