/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.cataclysm_custscenes.entities.ignis;

import com.finderfeed.cataclysm_custscenes.CatCutUtil;
import com.finderfeed.cataclysm_custscenes.CataclysmCutscenes;
import com.finderfeed.fdlib.init.FDScreenEffects;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CurveType;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFrame;
import com.finderfeed.fdlib.systems.impact_frames.ImpactFramesPacket;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.instances.datas.ScreenColorData;
import com.finderfeed.fdlib.systems.shake.DefaultShakePacket;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.util.FDTargetFinder;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.finderfeed.fdlib.util.rendering.FDEasings;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.Ignis_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

public class IgnisCutsceneEntity
extends Ignis_Entity
implements AutoSerializable {
    @SerializableField
    private ProjectileMovementPath movementPath;
    private BlockPos homepos;

    public static IgnisCutsceneEntity summon(Level level, Vec3 pos, BlockPos homePos) {
        pos = pos.m_82520_(0.0, 0.5, 0.0);
        IgnisCutsceneEntity cutsceneEntity = new IgnisCutsceneEntity(CataclysmCutscenes.IGNIS_CUTSCENE_ENTITY.get(), level);
        cutsceneEntity.homepos = homePos;
        cutsceneEntity.m_146884_(pos.m_82520_(0.0, 5.0, 0.0));
        cutsceneEntity.movementPath = IgnisCutsceneEntity.createPath(pos);
        cutsceneEntity.setHomePos(homePos);
        cutsceneEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, pos.m_82520_(0.0, 0.0, -100.0));
        List<ServerPlayer> affected = CatCutUtil.startCutsceneForPlayers((ServerLevel)level, pos, 60.0f, 300, IgnisCutsceneEntity.createCutsceneData(pos));
        List<ServerPlayer> inSurvival = affected.stream().filter(player -> !player.m_7500_() && !player.m_5833_()).toList();
        for (int i = 0; i < inSurvival.size(); ++i) {
            float p = (float)i / (float)inSurvival.size();
            float angle = (float)Math.PI * 2 * p;
            Vec3 optimalPos = pos.m_82549_(new Vec3(-20.0, 0.0, 0.0).m_82524_(angle));
            ServerPlayer serverPlayer = inSurvival.get(i);
            serverPlayer.m_6021_(optimalPos.f_82479_, optimalPos.f_82480_, optimalPos.f_82481_);
            serverPlayer.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
        }
        level.m_7967_((Entity)cutsceneEntity);
        return cutsceneEntity;
    }

    private static ProjectileMovementPath createPath(Vec3 pos) {
        ProjectileMovementPath movementPath = new ProjectileMovementPath(20, false);
        movementPath.addPos(pos.m_82520_(0.0, 5.0, 0.0));
        movementPath.addPos(pos.m_82520_(0.0, 6.0, -2.5));
        movementPath.addPos(pos.m_82520_(0.0, 7.0, -3.0));
        movementPath.addPos(pos.m_82520_(0.0, 3.0, -5.0));
        movementPath.addPos(pos.m_82520_(0.0, -2.0, -7.0));
        return movementPath;
    }

    private static CutsceneData createCutsceneData(Vec3 pos) {
        CutsceneData cutsceneData = CutsceneData.create().addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 0, 50).time(180).timeEasing(EasingType.EASE_IN_OUT);
        CameraPos lastPos = null;
        int c = 24;
        float angle = (float)Math.PI * 2 / (float)c;
        for (int i = 0; i <= c; ++i) {
            Vec3 v = new Vec3(0.0, 0.0, -1.0).m_82524_((float)i * angle);
            float p = (float)i / ((float)c - 1.0f);
            float radius = FDMathUtil.lerp((float)10.0f, (float)25.0f, (float)(1.0f - p));
            float height = FDMathUtil.lerp((float)0.0f, (float)8.0f, (float)p);
            Vec3 offset = v.m_82490_((double)radius).m_82520_(0.0, (double)(height - 2.0f), 0.0);
            Vec3 camPos = pos.m_82549_(offset);
            Vec3 look = camPos.m_82546_(pos.m_82520_(0.0, 5.0, 0.0)).m_82541_().m_82548_().m_82524_(-angle / 2.0f * FDEasings.easeIn((float)(1.0f - p)));
            lastPos = new CameraPos(camPos, look);
            cutsceneData.addCameraPos(lastPos);
        }
        CutsceneData cutsceneData2 = new CutsceneData().time(20).timeEasing(EasingType.EASE_IN_OUT).addCameraPos(lastPos);
        lastPos = new CameraPos(lastPos.getPos().m_82520_(0.0, 0.0, 3.0), new Vec3(0.0, 0.0, 1.0));
        CutsceneData cutsceneData22 = cutsceneData2.addCameraPos(lastPos);
        CutsceneData cutsceneData3 = new CutsceneData().time(30).timeEasing(EasingType.EASE_IN_OUT).moveCurveType(CurveType.CATMULLROM).addCameraPos(lastPos).addCameraPos(new CameraPos(lastPos.getPos().m_82520_(0.0, -2.0, -3.0), new Vec3(0.0, 1.0, 1.0))).addCameraPos(new CameraPos(lastPos.getPos().m_82520_(0.0, -5.0, -5.0), new Vec3(0.0, 1.0, 1.0)));
        lastPos = new CameraPos(lastPos.getPos().m_82520_(0.0, -6.0, -6.0), new Vec3(0.0, 0.0, 1.0));
        CutsceneData cutsceneData32 = cutsceneData3.addCameraPos(lastPos);
        CutsceneData cutsceneData4 = new CutsceneData().addCameraPos(lastPos).time(120).addScreenEffect(100, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 20, 10, 20);
        cutsceneData.nextCutscene(cutsceneData22.nextCutscene(cutsceneData32.nextCutscene(cutsceneData4)));
        return cutsceneData;
    }

    public IgnisCutsceneEntity(EntityType<? extends IgnisCutsceneEntity> entity, Level world) {
        super(entity, world);
    }

    public void m_8119_() {
        this.m_6710_(null);
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.movementPath == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.tickCutscene();
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    private void tickCutscene() {
        int summoningRitualDuration = 200;
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ < 20) {
                this.setIsShieldBreak(true);
                this.setShieldDurability(0);
            }
            if (this.f_19797_ == summoningRitualDuration - 20) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SMASH_IN_AIR);
                for (ServerPlayer serverPlayer : FDTargetFinder.getEntitiesInCylinder(ServerPlayer.class, (Level)this.m_9236_(), (Vec3)this.m_20182_().m_82520_(0.0, -10.0, 0.0), (float)40.0f, (float)40.0f)) {
                    FDPacketHandler.INSTANCE.sendTo((Object)new DefaultShakePacket(FDShakeData.builder().inTime(20).outTime(10).amplitude(1.0f).build()), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (this.f_19797_ == summoningRitualDuration + 15) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, SMASH);
            } else if (this.f_19797_ == summoningRitualDuration + 22) {
                for (ServerPlayer serverPlayer : FDTargetFinder.getEntitiesInCylinder(ServerPlayer.class, (Level)this.m_9236_(), (Vec3)this.m_20182_().m_82520_(0.0, -10.0, 0.0), (float)40.0f, (float)40.0f)) {
                    FDPacketHandler.INSTANCE.sendTo((Object)new DefaultShakePacket(FDShakeData.builder().outTime(5).amplitude(1.5f).build()), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (this.f_19797_ == summoningRitualDuration + 55) {
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, HORIZONTAL_SWING_ATTACK);
            } else if (this.f_19797_ == summoningRitualDuration + 85) {
                this.setShowShield(true);
            } else if (this.f_19797_ == summoningRitualDuration - 2) {
                ImpactFramesPacket impactFramesPacket = new ImpactFramesPacket(List.of(new ImpactFrame().setDuration(2), new ImpactFrame().setDuration(1).setInverted(true), new ImpactFrame().setDuration(1), new ImpactFrame().setDuration(1).setInverted(true), new ImpactFrame().setDuration(1)));
                for (ServerPlayer serverPlayer : FDTargetFinder.getEntitiesInCylinder(ServerPlayer.class, (Level)this.m_9236_(), (Vec3)this.m_20182_().m_82520_(0.0, -10.0, 0.0), (float)40.0f, (float)40.0f)) {
                    FDPacketHandler.INSTANCE.sendTo((Object)impactFramesPacket, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (this.f_19797_ == summoningRitualDuration) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0f, 0.75f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12513_, SoundSource.HOSTILE, 4.0f, 0.75f);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.IGNIS_HURT.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
            } else if (this.f_19797_ >= summoningRitualDuration + 155) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                Ignis_Entity ignisEntity = (Ignis_Entity)((EntityType)ModEntities.IGNIS.get()).m_20615_(this.m_9236_());
                ignisEntity.setHomePos(this.homepos);
                ignisEntity.setDimensionType(this.m_9236_().m_46472_().m_135782_().toString());
                ignisEntity.m_146884_(this.m_20182_());
                this.m_9236_().m_7967_((Entity)ignisEntity);
            }
            if (this.f_19797_ > summoningRitualDuration - 1) {
                if (!this.movementPath.isFinished()) {
                    this.movementPath.tick((Entity)this);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            }
        } else {
            this.swordProgress = 10.0f;
            this.prevswordProgress = 10.0f;
            this.startingRitualParticles(summoningRitualDuration);
            if (this.f_19797_ > summoningRitualDuration && this.f_19797_ <= summoningRitualDuration + 4) {
                this.ignisSpawnExplosion(this.m_20182_().m_82520_(0.0, 2.0, 0.0));
            }
            if (this.f_19797_ == summoningRitualDuration + 85) {
                this.ignisSpawnExplosion(this.m_20182_().m_82549_(this.m_20154_().m_82490_(2.0)));
            }
            if (this.f_19797_ < summoningRitualDuration) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)this.f_19796_.m_188501_() - 0.5 + 0.5, this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)this.f_19796_.m_188501_() - 0.5 + 0.5, this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, (double)this.f_19796_.m_188501_() * 0.2 - 0.1, (double)this.f_19796_.m_188501_() * 0.2 - 0.1, (double)this.f_19796_.m_188501_() * 0.2 - 0.1);
                if (this.f_19797_ < summoningRitualDuration - 10 && this.f_19797_ % 2 == 0) {
                    this.particlesFromAltar((float)(-this.f_19797_) / 15.0f);
                    this.particlesFromAltar((float)(-this.f_19797_) / 15.0f + (float)Math.PI);
                }
            }
        }
    }

    private void particlesFromAltar(float angleOffset) {
        int c = 12;
        float angle = (float)Math.PI / (float)c;
        for (int i = 0; i <= c; ++i) {
            float p = (float)i / ((float)c - 1.0f);
            Vec3 v = new Vec3(0.0, 0.0, -0.6 * (double)FDEasings.easeOut((float)(1.0f - p))).m_82524_((float)i * angle + angleOffset);
            float height = FDMathUtil.lerp((float)-5.0f, (float)0.0f, (float)p);
            Vec3 ppos = this.m_20182_().m_82520_(0.0, (double)height, 0.0).m_82549_(v);
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, ppos.f_82479_, ppos.f_82480_, ppos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    private void startingRitualParticles(int duration) {
        float p = (float)this.f_19797_ / (float)duration;
        if (this.f_19797_ < duration) {
            Vec3 center = this.m_20182_().m_82520_(0.0, (double)(FDMathUtil.lerp((float)-2.0f, (float)6.0f, (float)(p * p * p * p)) - 5.0f), 0.0);
            Vec3 center2 = this.m_20182_().m_82520_(0.0, (double)(FDMathUtil.lerp((float)15.0f, (float)6.0f, (float)(p * p * p * p)) - 5.0f), 0.0);
            this.createParticlesOnCircle((ParticleOptions)ParticleTypes.f_123744_, center, 30.0f * (1.0f - p), 12, 4.712389f * p * p * p);
            this.createParticlesOnCircle((ParticleOptions)ParticleTypes.f_123744_, center2, 30.0f * (1.0f - p), 12, -4.712389f * p * p * p);
        }
    }

    private void ignisSpawnExplosion(Vec3 center) {
        float size = 3.0f;
        for (float i = -size; i <= size; i += 1.0f) {
            for (float j = -size; j <= size; j += 1.0f) {
                for (float k = -size; k <= size; k += 1.0f) {
                    double d3 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d4 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d5 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                    double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.m_188583_() * 0.05;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_, center.f_82481_, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2.0f - 1.0f;
                }
            }
        }
    }

    private void createParticlesOnCircle(ParticleOptions options, Vec3 center, float radius, int count, float startAngle) {
        float angle = (float)Math.PI * 2 / (float)count;
        for (int i = 0; i < count; ++i) {
            Vec3 v = new Vec3((double)radius, 0.0, 0.0).m_82524_((float)i * angle + startAngle);
            Vec3 pos = center.m_82549_(v);
            this.m_9236_().m_6493_(options, true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected void m_8099_() {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
    }

    public void m_6452_(ServerPlayer player) {
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return (source.m_276093_(DamageTypes.f_286979_) || source.m_276093_(DamageTypes.f_268724_)) && super.m_6469_(source, damage);
    }

    protected void m_6153_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5501_() {
        return null;
    }

    protected void ReturnToHome() {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.autoLoad(compound);
        this.homepos = new BlockPos(compound.m_128451_("chomePosX"), compound.m_128451_("chomePosY"), compound.m_128451_("chomePosZ"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.autoSave(compound);
        compound.m_128405_("chomePosX", this.homepos.m_123341_());
        compound.m_128405_("chomePosY", this.homepos.m_123342_());
        compound.m_128405_("chomePosZ", this.homepos.m_123343_());
    }

    @Mod.EventBusSubscriber(modid="cinematiccataclysm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void livingDestroyBlockEvent(LivingDestroyBlockEvent event) {
            if (event.getEntity() instanceof IgnisCutsceneEntity) {
                event.setCanceled(true);
            }
        }
    }
}

