/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.util;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class ItemUtils {
    public static double getItemAttackDamage(LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0.0;
        }
        AtomicReference<Double> totalDamage = livingEntity != null ? new AtomicReference<Double>(livingEntity.m_21172_(Attributes.f_22281_)) : new AtomicReference<Double>(0.0);
        itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).forEach(attributeModifier -> {
            if (attributeModifier.m_22217_().equals((Object)AttributeModifier.Operation.ADDITION)) {
                totalDamage.updateAndGet(v -> v + attributeModifier.m_22218_());
            }
        });
        return totalDamage.get();
    }

    public static ArrayList<ItemStack> calculateValidBabylonItems(ServerPlayer player, boolean shouldDelete) {
        return ItemUtils.calculateValidBabylonItems(player, shouldDelete, itemStack -> true);
    }

    public static ArrayList<ItemStack> calculateValidBabylonItems(ServerPlayer player, boolean shouldDelete, Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> validBabylonItems = new ArrayList<ItemStack>();
        player.m_150109_().f_35974_.forEach(itemStack -> {
            boolean isItemHandler = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
            if (isItemHandler) {
                itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                    for (int i = 0; i < iItemHandler.getSlots(); ++i) {
                        ItemStack inSideItem = iItemHandler.getStackInSlot(i);
                        if (inSideItem.m_41619_() || !predicate.test(inSideItem)) continue;
                        validBabylonItems.add(inSideItem.m_41777_());
                        if (!shouldDelete) continue;
                        inSideItem.m_41764_(0);
                    }
                });
            } else if (!itemStack.m_41619_() && predicate.test((ItemStack)itemStack)) {
                validBabylonItems.add(itemStack.m_41777_());
                if (shouldDelete) {
                    itemStack.m_41764_(0);
                }
            }
        });
        ArrayList<ItemStack> enderChestStacks = new ArrayList<ItemStack>();
        PlayerEnderChestContainer enderChestContainer = player.m_36327_();
        for (int i = 0; i < enderChestContainer.m_6643_(); ++i) {
            ItemStack itemStack2 = enderChestContainer.m_8020_(i);
            if (itemStack2.m_41619_() || !predicate.test(itemStack2)) continue;
            enderChestStacks.add(itemStack2.m_41777_());
            if (!shouldDelete) continue;
            itemStack2.m_41764_(0);
        }
        validBabylonItems.addAll(enderChestStacks);
        return validBabylonItems;
    }
}

