/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.weapon_passive;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.vatansever.VatanseverEntity;
import net.p1nero.ss.entity.vatansever.VatanseverEntityPatch;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.VatanseverAnimations;
import net.p1nero.ss.gameassets.skills.VatanseverSkills;
import net.p1nero.ss.item.VatanseverItem;
import net.p1nero.ss.skill.weapon_passive.ArtifactSpiritPassiveSkill;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class VatanseverPassive
extends ArtifactSpiritPassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("d1d114cc-f30f-11ed-a05b-0242ac114514");

    public VatanseverPassive(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public boolean canExecute(SkillContainer container) {
        return super.canExecute(container) && ((Player)container.getExecutor().getOriginal()).m_21205_().m_41720_() instanceof VatanseverItem;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        Skill lastDodge = container.getExecutor().getSkill((SkillSlot)SkillSlots.DODGE).getSkill();
        ((Player)container.getExecutor().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> ssPlayer.setLastDodgeSkill(lastDodge == VatanseverSkills.VATANSEVER_DODGE ? null : lastDodge));
        container.getExecutor().getSkill((SkillSlot)SkillSlots.DODGE).setSkill(VatanseverSkills.VATANSEVER_DODGE);
        container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get(), (Object)6);
        this.summonVatansever(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID, skillExecuteEvent -> {
            if (!(skillExecuteEvent.getPlayerPatch().isLogicalClient() || ((Player)skillExecuteEvent.getPlayerPatch().getOriginal()).m_9236_().m_6815_(this.getArtifactSpiritId(container)) instanceof VatanseverEntity || this.summonVatansever(container))) {
                container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get(), (Object)0);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.SET_TARGET_EVENT, EVENT_UUID, setTargetEvent -> {
            if (setTargetEvent.getTarget() instanceof VatanseverEntity) {
                ((ServerPlayerPatch)setTargetEvent.getPlayerPatch()).setAttackTarget(null);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID, indicatorCheckEvent -> {
            if (indicatorCheckEvent.getTarget() instanceof VatanseverEntityPatch) {
                indicatorCheckEvent.setCanceled(true);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, hurtEvent -> {
            Player player = (Player)((ServerPlayerPatch)hurtEvent.getPlayerPatch()).getOriginal();
            if (player.m_21255_()) {
                double power = player.m_20184_().m_82553_();
                if (power > 1.0) {
                    LevelUtil.circleSlamFracture((LivingEntity)player, (Level)player.m_9236_(), (Vec3)player.m_20182_().m_82520_(0.0, -1.0, 0.0), (double)(power * 2.0));
                }
                hurtEvent.setCanceled(true);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, fallEvent -> {
            Player player = (Player)fallEvent.getPlayerPatch().getOriginal();
            double power = player.m_20184_().m_82553_();
            if (power > 1.0) {
                LevelUtil.circleSlamFracture((LivingEntity)player, (Level)player.m_9236_(), (Vec3)player.m_20182_().m_82520_(0.0, -1.0, 0.0), (double)(power * 2.0));
            }
            fallEvent.getForgeEvent().setCanceled(true);
            player.m_36321_();
        });
    }

    public boolean summonVatansever(SkillContainer container) {
        if (!container.getExecutor().isLogicalClient() && (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get()) == 0) {
            VatanseverEntity vatanseverEntity = new VatanseverEntity(((Player)container.getExecutor().getOriginal()).m_9236_(), (Player)container.getExecutor().getOriginal());
            boolean success = ((Player)container.getExecutor().getOriginal()).m_9236_().m_7967_((Entity)vatanseverEntity);
            container.getExecutor().playAnimationSynchronized(VatanseverAnimations.PLAYER_INIT, 0.15f);
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get(), (Object)vatanseverEntity.m_19879_());
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.SWORD_COUNT.get(), (Object)6);
            return success;
        }
        return false;
    }

    public void onRemoved(SkillContainer container) {
        VatanseverEntity abstractArtifactSpiritEntity;
        Entity entity;
        super.onRemoved(container);
        ((Player)container.getExecutor().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> container.getExecutor().getSkill((SkillSlot)SkillSlots.DODGE).setSkill(ssPlayer.getLastDodgeSkill()));
        int id = this.getArtifactSpiritId(container);
        if (id != 0 && (entity = ((Player)container.getExecutor().getOriginal()).m_9236_().m_6815_(id)) instanceof VatanseverEntity && (abstractArtifactSpiritEntity = (VatanseverEntity)entity).m_6084_()) {
            abstractArtifactSpiritEntity.m_146870_();
        }
        ((Player)container.getExecutor().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(SSPlayer::clearVatanseverShootEntities);
        container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get(), (Object)0);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SET_TARGET_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        VatanseverEntityPatch vatanseverEntityPatch;
        ServerPlayerPatch serverPlayerPatch;
        SkillDataManager manager;
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (serverPlayer = (ServerPlayer)livingEntity).m_6084_() && (manager = (serverPlayerPatch = (ServerPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer, ServerPlayerPatch.class)).getSkill((SkillSlot)SkillSlots.WEAPON_PASSIVE).getDataManager()).hasData((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get()) && (vatanseverEntityPatch = (VatanseverEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)serverPlayer.m_9236_().m_6815_(((Integer)manager.getDataValue((SkillDataKey)SwordSoaringDatakeys.ARTIFACT_SPIRIT_ENTITY_ID.get())).intValue()), VatanseverEntityPatch.class)) != null && vatanseverEntityPatch.getEntityState().inaction()) {
            event.setResult(Event.Result.DENY);
        }
    }
}

