/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.SwordSoaringConfig;
import net.p1nero.ss.SwordSoaringMod;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import net.p1nero.ss.client.sound.WanSoundInstance;
import net.p1nero.ss.entity.sword.fly_sword.FlySwordEntity;
import net.p1nero.ss.entity.sword.wan.WanEntity;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.FlySwordAnimations;
import net.p1nero.ss.gameassets.animations.WanAnimations;
import net.p1nero.ss.util.ItemUtils;
import yesman.epicfight.client.events.engine.ControlEngine;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class WanJianGuiZongSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("d2d810cc-f30f-11ed-a05b-0242ac114581");
    private static int cooldown;

    public WanJianGuiZongSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        cooldown = parameters.m_128451_("cooldown");
    }

    public static int getMaxCooldown() {
        return cooldown;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayerPatch)event.getPlayerPatch()).getPlayerMode() == PlayerPatch.PlayerMode.EPICFIGHT && SwordSoaringKeyMappings.SWORD_SKILL.m_90857_()) {
                Input input = event.getMovementInput();
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108572_ = false;
                input.f_108573_ = false;
                LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
                clientPlayer.m_6858_(false);
                clientPlayer.f_108583_ = -1;
                ControlEngine.setSprintingKeyStateNotDown();
            }
        });
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) <= 0 || ((Player)executor.getOriginal()).m_7500_()) && ((Player)executor.getOriginal()).m_20096_() && SwordSoaringMod.isValidSword(((Player)executor.getOriginal()).m_21205_());
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        ArrayList<ItemStack> firstHalf;
        ArrayList<ItemStack> secondHalf;
        ServerPlayerPatch executer = container.getServerExecutor();
        super.executeOnServer(container, args);
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)cooldown);
        executer.playAnimationSynchronized(WanAnimations.WAN1_PLAYER, 0.15f);
        ArrayList<ItemStack> list = ItemUtils.calculateValidBabylonItems((ServerPlayer)executer.getOriginal(), false, SwordSoaringMod::isValidSword);
        ((ServerPlayer)executer.getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> ssPlayer.setWanSwordList(list));
        if (list.size() <= 1) {
            firstHalf = secondHalf = list;
        } else {
            firstHalf = new ArrayList<ItemStack>(list.subList(0, list.size() / 2));
            secondHalf = new ArrayList<ItemStack>(list.subList(list.size() / 2, list.size()));
        }
        WanEntity leftOne = new WanEntity((LivingEntity)executer.getOriginal());
        leftOne.setAnimationToPlay(WanAnimations.WAN1_L);
        leftOne.initBabylonItems(firstHalf, true);
        ((ServerPlayer)executer.getOriginal()).m_9236_().m_7967_((Entity)leftOne);
        WanEntity rightOne = new WanEntity((LivingEntity)executer.getOriginal());
        rightOne.setAnimationToPlay(WanAnimations.WAN1_R);
        rightOne.initBabylonItems(secondHalf, true);
        ((ServerPlayer)executer.getOriginal()).m_9236_().m_7967_((Entity)rightOne);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new WanSoundInstance(container.getClientExecutor()));
    }

    public void updateContainer(SkillContainer container) {
        int currentCooldown;
        boolean isKeyDown;
        super.updateContainer(container);
        if (container.getExecutor().isLogicalClient() && (isKeyDown = SwordSoaringKeyMappings.SWORD_SKILL.m_90857_()) != (Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.IS_PRESSING.get())) {
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.IS_PRESSING.get(), (Object)isKeyDown);
        }
        if ((currentCooldown = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get())).intValue()) > 0 && !container.getExecutor().isLogicalClient()) {
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)(currentCooldown - 1));
        }
        if (!container.getExecutor().isLogicalClient() && cooldown - currentCooldown <= 128) {
            for (int i = 0; i < (Integer)SwordSoaringConfig.SWORD_EFFECT_PER_TICK.get(); ++i) {
                FlySwordEntity flySwordEntity = new FlySwordEntity((LivingEntity)container.getExecutor().getOriginal(), 200, (LivingEntity)container.getExecutor().getOriginal());
                flySwordEntity.setAnimationToPlay(FlySwordAnimations.WAN_ANIMATIONS.get(currentCooldown % FlySwordAnimations.WAN_ANIMATIONS.size()));
                flySwordEntity.setRotationLock(false);
                float randomRot = new Random().nextFloat() * 360.0f;
                flySwordEntity.m_146922_(randomRot);
                flySwordEntity.m_5618_(randomRot);
                flySwordEntity.m_5616_(randomRot);
                ((Player)container.getExecutor().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> flySwordEntity.setItemStack(ssPlayer.getWanSwordList().get(currentCooldown % ssPlayer.getWanSwordList().size())));
                ((Player)container.getExecutor().getOriginal()).m_9236_().m_7967_((Entity)flySwordEntity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) > 0;
    }

    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get())).intValue() / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add((double)cooldown / 20.0);
        list.add(SwordSoaringKeyMappings.SWORD_SKILL.m_90863_());
        return list;
    }
}

