/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.skill.sword_controller;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.SwordSoaringMod;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import net.p1nero.ss.entity.sword.fly_sword.FlySwordEntity;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.animations.ScreenSwordAnimations;
import net.p1nero.ss.util.vfx.ParticleVFX;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class RainSwordSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-1145-14ee-b962-0242ac191981");
    private int lifeTime;
    private int minCount;
    private int maxCount;
    private int interval;
    private int cooldown;

    public RainSwordSkill(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.interval = parameters.m_128451_("interval");
        this.lifeTime = parameters.m_128451_("life_time");
        this.minCount = parameters.m_128451_("min_count");
        this.maxCount = parameters.m_128451_("max_count");
        this.cooldown = parameters.m_128451_("cooldown");
        this.cooldown += this.lifeTime;
        if (this.minCount > this.maxCount) {
            throw new IllegalArgumentException("max count can not be less than min count!");
        }
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, basicAttackEvent -> {
            LivingEntity target = ((ServerPlayerPatch)basicAttackEvent.getPlayerPatch()).getTarget();
            int currentLifeTime = this.cooldown - (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
            if (currentLifeTime < this.lifeTime && target != null) {
                int count = ((ServerPlayer)((ServerPlayerPatch)basicAttackEvent.getPlayerPatch()).getOriginal()).m_217043_().m_216339_(this.minCount, this.maxCount);
                container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.DELAY_TIMER.get(), (Object)(count * this.interval));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID, skillExecuteEvent -> container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.PLAY_BIG_DIPPER.get(), (Object)true));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_ATTACK, EVENT_UUID);
    }

    public boolean canExecute(SkillContainer container) {
        PlayerPatch executor = container.getExecutor();
        return ((Player)executor.getOriginal()).m_20096_() && SwordSoaringMod.isValidSword(executor.getValidItemInHand(InteractionHand.MAIN_HAND)) && ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) <= 0 || ((Player)executor.getOriginal()).m_7500_());
    }

    public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
        super.executeOnServer(container, args);
        ServerPlayerPatch executer = container.getServerExecutor();
        container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)this.cooldown);
        executer.playAnimationSynchronized(ScreenSwordAnimations.PLAYER_SUMMON_RAIN_SWORD, 0.15f);
        executer.playSound(SoundEvents.f_11868_, 0.0f, 0.0f);
    }

    public void updateContainer(SkillContainer container) {
        int delayTimer;
        int currentLifetime;
        super.updateContainer(container);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        if (currentCooldown > 0) {
            container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get(), (Object)(currentCooldown - 1));
        }
        if ((currentLifetime = this.cooldown - currentCooldown) < this.lifeTime && container.getExecutor().isLogicalClient()) {
            Player player = (Player)container.getExecutor().getOriginal();
            if (currentLifetime <= 10) {
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_146892_(), -1.0f, 0.8f, player.m_146908_(), 0.0f, -0.1f, 0.0f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_175829_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), 0.1f, 0.8f, player.m_146908_(), 0.0f, 0.0f, 0.0f);
            } else if (currentLifetime % 60 == 0) {
                boolean b = currentLifetime % 120 == 0;
                container.getExecutor().playSound(b ? SoundEvents.f_144054_ : SoundEvents.f_144049_, 2.5f, -0.5f, 0.5f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), -1.0f, 1.5f, currentLifetime, 0.0f, 0.05f, 0.0f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), -1.0f, 1.5f, currentLifetime, 0.0f, 0.0f, 0.0f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), -1.0f, 1.5f, currentLifetime, 0.0f, -0.05f, 0.0f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_175828_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), b ? -1.0f : 0.1f, 1.5f, currentLifetime, 0.0f, 0.0f, 0.0f);
                ParticleVFX.createBigDipperXZParticle((ParticleOptions)ParticleTypes.f_175829_, player.m_9236_(), player.m_20182_().m_82520_(0.0, 0.3, 0.0), b ? 0.1f : -1.0f, 1.5f, currentLifetime, 0.0f, 0.0f, 0.0f);
            }
        }
        if ((delayTimer = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.DELAY_TIMER.get())).intValue()) > 0) {
            LivingEntity target;
            if (!container.getExecutor().isLogicalClient() && delayTimer % this.interval == 0 && (target = container.getExecutor().getTarget()) != null) {
                FlySwordEntity flySwordEntity = new FlySwordEntity((LivingEntity)container.getExecutor().getOriginal(), -114, target);
                flySwordEntity.setRotationLock(false);
                float yRot = (float)delayTimer * 1.0f / (float)this.interval / (float)this.maxCount * 360.0f;
                flySwordEntity.m_146922_(yRot);
                flySwordEntity.m_5618_(yRot);
                flySwordEntity.m_5616_(yRot);
                target.m_9236_().m_7967_((Entity)flySwordEntity);
            }
            container.getDataManager().setData((SkillDataKey)SwordSoaringDatakeys.DELAY_TIMER.get(), (Object)(delayTimer - 1));
        }
        if (((Boolean)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.PLAY_BIG_DIPPER.get())).booleanValue() && container.getExecutor().isLogicalClient()) {
            if (currentLifetime > this.lifeTime) {
                return;
            }
            Player player = (Player)container.getExecutor().getOriginal();
            boolean b = player.m_217043_().m_188499_();
            ParticleVFX.createBigDipperXYParticle((ParticleOptions)ParticleTypes.f_123810_, player.m_9236_(), player.m_146892_().m_82520_(0.0, 1.0, 0.0), -1.0f, 0.8f, player.m_146908_(), currentLifetime, 0.0f, 0.0f, 0.0f);
            ParticleVFX.createBigDipperXYParticle((ParticleOptions)ParticleTypes.f_175828_, player.m_9236_(), player.m_146892_().m_82520_(0.0, 1.0, 0.0), b ? -1.0f : 0.1f, 0.8f, player.m_146908_(), currentLifetime, 0.0f, 0.0f, 0.0f);
            ParticleVFX.createBigDipperXYParticle((ParticleOptions)ParticleTypes.f_175829_, player.m_9236_(), player.m_146892_().m_82520_(0.0, 1.0, 0.0), b ? 0.1f : -1.0f, 0.8f, player.m_146908_(), currentLifetime, 0.0f, 0.0f, 0.0f);
            container.getDataManager().setDataSync((SkillDataKey)SwordSoaringDatakeys.PLAY_BIG_DIPPER.get(), (Object)false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.minCount);
        list.add(this.maxCount);
        list.add((double)this.lifeTime / 20.0);
        list.add((double)this.cooldown / 20.0);
        list.add(SwordSoaringKeyMappings.SWORD_SKILL.m_90863_());
        return list;
    }

    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get()) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y, float partialTick) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)gui.getSlidingProgression(), 0.0f);
        guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        int currentCooldown = (Integer)container.getDataManager().getDataValue((SkillDataKey)SwordSoaringDatakeys.COOLDOWN_TIMER.get());
        int currentLifetime = this.cooldown - currentCooldown;
        if (currentLifetime > this.lifeTime) {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)currentCooldown / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        } else {
            guiGraphics.drawString(gui.getFont(), String.format("%.1f", (double)(this.lifeTime - currentLifetime) / 20.0), x + 6.0f, y + 8.0f, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }
}

