/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.network.packet.client;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonEntity;
import net.p1nero.ss.network.packet.BasePacket;
import org.jetbrains.annotations.Nullable;

public record SyncBabylonPacket(int id, int size, ArrayList<ItemStack> itemStacks) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.itemStacks.size());
        this.itemStacks.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130055_(arg_0));
    }

    public static SyncBabylonPacket decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        int size = buf.readInt();
        ArrayList<ItemStack> newItemStack = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            newItemStack.add(buf.m_130267_());
        }
        return new SyncBabylonPacket(id, size, newItemStack);
    }

    @Override
    public void execute(@Nullable Player player) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.id);
            if (entity instanceof Player) {
                Player localPlayer = (Player)entity;
                localPlayer.getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(ssPlayer -> ssPlayer.updateBabylonItems(this.itemStacks));
            }
            if (entity instanceof BabylonEntity) {
                BabylonEntity babylonEntity = (BabylonEntity)entity;
                babylonEntity.updateBabylonItems(this.itemStacks);
            }
        }
    }
}

