/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.sword.gate_of_babylon;

import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.p1nero.ss.entity.AbstractArtifactSpiritPatch;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonEntity;
import net.p1nero.ss.gameassets.SwordSoaringColliders;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.server.RequestEntityPlayAnimationPacket;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.collider.Collider;

public abstract class AbstractBabylonPatch<T extends BabylonEntity>
extends AbstractArtifactSpiritPatch<T> {
    protected boolean played;
    protected float baseDamage;

    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick(LivingEvent.LivingTickEvent event) {
        super.clientTick(event);
        if (!this.played && this.isLogicalClient() && this.getOwnerPatch() != null) {
            if (!((Player)this.getOwnerPatch().getOriginal()).equals((Object)Minecraft.m_91087_().f_91074_)) {
                return;
            }
            AnimationManager.AnimationAccessor<? extends StaticAnimation> toPlay = ((BabylonEntity)this.getOriginal()).getAnimationToPlay();
            if (toPlay != null) {
                PacketRelay.sendToServer(PacketHandler.INSTANCE, new RequestEntityPlayAnimationPacket(((BabylonEntity)this.getOriginal()).m_19879_(), toPlay.id(), 1.0E-4f));
                this.played = true;
            }
        }
    }

    public Collider getColliderMatching(InteractionHand hand) {
        return SwordSoaringColliders.FLY_SWORD_COMMON;
    }

    @Override
    public boolean shouldUseOwnerAttack() {
        return false;
    }

    public void setModifiedBaseDamage(float modifiedBaseDamage) {
        this.baseDamage = modifiedBaseDamage;
    }

    public float getModifiedBaseDamage(float baseDamage) {
        return this.baseDamage;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        this.keepIdleMotion(considerInaction);
    }
}

