/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.ray.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.entity.ray.RayEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RayRenderer
extends EntityRenderer<RayEntity> {
    public static final ResourceLocation RAY = ResourceLocation.fromNamespaceAndPath((String)"sword_soaring", (String)"textures/entity/ray.png");

    public RayRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull RayEntity pEntity) {
        return RAY;
    }

    public void render(RayEntity entity, float yaw, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight) {
        Vec3 start = entity.getStartPos();
        Vec3 end = entity.getEndPos();
        RayRenderer.renderRay(entity, start, end, poseStack, buffer, partialTicks);
    }

    public static void renderRay(Entity entity, Vec3 begin, Vec3 end, PoseStack poseStack, MultiBufferSource bufferSource, float partialTicks) {
        poseStack.m_85836_();
        PoseStack.Pose pose = poseStack.m_85850_();
        Vec3 start = Vec3.f_82478_;
        Vec3 direction = end.m_82546_(begin);
        float distance = (float)direction.m_82553_();
        if ((double)distance < 1.0E-6) {
            poseStack.m_85849_();
            return;
        }
        direction = direction.m_82541_();
        float yaw = (float)Math.toDegrees(Math.atan2(direction.f_82481_, direction.f_82479_)) - 90.0f;
        float pitch = (float)(-Math.toDegrees(Math.asin(direction.f_82480_)));
        Vec3 entityPos = entity.m_20318_(partialTicks);
        Vec3 offset = begin.m_82546_(entityPos);
        poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-yaw));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
        float radius = 0.5f;
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        float deltaTicks = (float)entity.f_19797_ + partialTicks;
        float deltaUV = -deltaTicks % 10.0f;
        float max = Mth.m_14187_((float)(deltaUV * 0.2f - (float)Mth.m_14143_((float)(deltaUV * 0.1f))));
        float min = -1.0f + max;
        for (float j = 0.5f; j <= distance; j += 0.5f) {
            Vec3 currentEnd = new Vec3(0.0, 0.0, (double)Math.min(j, distance));
            VertexConsumer inner = bufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)RAY, (boolean)true));
            RayRenderer.drawHull(start, currentEnd, radius, radius, pose, inner, r, g, b, a, min, max);
            start = currentEnd;
        }
        poseStack.m_85849_();
    }

    private static void drawHull(Vec3 from, Vec3 to, float width, float height, PoseStack.Pose pose, VertexConsumer consumer, int r, int g, int b, int a, float uvMin, float uvMax) {
        RayRenderer.drawQuad(from.m_82492_(0.0, (double)(height * 0.5f), 0.0), to.m_82492_(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, pose, consumer, r, g, b, a, uvMin, uvMax);
        RayRenderer.drawQuad(from.m_82520_(0.0, (double)(height * 0.5f), 0.0), to.m_82520_(0.0, (double)(height * 0.5f), 0.0), width, 0.0f, pose, consumer, r, g, b, a, uvMin, uvMax);
        RayRenderer.drawQuad(from.m_82492_((double)(width * 0.5f), 0.0, 0.0), to.m_82492_((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, pose, consumer, r, g, b, a, uvMin, uvMax);
        RayRenderer.drawQuad(from.m_82520_((double)(width * 0.5f), 0.0, 0.0), to.m_82520_((double)(width * 0.5f), 0.0, 0.0), 0.0f, height, pose, consumer, r, g, b, a, uvMin, uvMax);
    }

    private static void drawQuad(Vec3 from, Vec3 to, float width, float height, PoseStack.Pose pose, VertexConsumer consumer, int r, int g, int b, int a, float uvMin, float uvMax) {
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        float halfWidth = width * 0.5f;
        float halfHeight = height * 0.5f;
        consumer.m_252986_(poseMatrix, (float)from.f_82479_ - halfWidth, (float)from.f_82480_ - halfHeight, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)from.f_82479_ + halfWidth, (float)from.f_82480_ + halfHeight, (float)from.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)to.f_82479_ + halfWidth, (float)to.f_82480_ + halfHeight, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(1.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(poseMatrix, (float)to.f_82479_ - halfWidth, (float)to.f_82480_ - halfHeight, (float)to.f_82481_).m_6122_(r, g, b, a).m_7421_(0.0f, uvMin).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

