/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity.ray;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.p1nero.ss.entity.SwordSoaringEntities;
import org.joml.Vector3f;

public class RayEntity
extends Entity {
    private static final EntityDataAccessor<Vector3f> START_POS = SynchedEntityData.m_135353_(RayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Vector3f> END_POS = SynchedEntityData.m_135353_(RayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(RayEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public RayEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            // empty if block
        }
        if (this.f_19797_ > 1) {
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(START_POS, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(END_POS, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void setOwner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(owner.m_20148_()));
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        Level level;
        Optional uuid = (Optional)this.f_19804_.m_135370_(OWNER_UUID);
        if (uuid.isPresent() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity entity = serverLevel.m_8791_((UUID)uuid.get());
            return entity instanceof LivingEntity ? (LivingEntity)entity : null;
        }
        return null;
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128403_("Owner")) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(pCompound.m_128342_("Owner")));
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        Optional uuid = (Optional)this.f_19804_.m_135370_(OWNER_UUID);
        uuid.ifPresent(value -> pCompound.m_128362_("Owner", value));
    }

    public static void spawnRay(Level level, LivingEntity owner, Vec3 start, Vec3 end) {
        RayEntity ray = new RayEntity((EntityType)SwordSoaringEntities.RAY_ENTITY.get(), level);
        ray.setOwner(owner);
        ray.updatePositions(start, end);
        level.m_7967_((Entity)ray);
    }

    public void updatePositions(Vec3 newStart, Vec3 newEnd) {
        this.f_19804_.m_135381_(START_POS, (Object)new Vector3f((float)newStart.f_82479_, (float)newStart.f_82480_, (float)newStart.f_82481_));
        this.f_19804_.m_135381_(END_POS, (Object)new Vector3f((float)newEnd.f_82479_, (float)newEnd.f_82480_, (float)newEnd.f_82481_));
        this.m_6034_(newStart.f_82479_, newStart.f_82480_, newStart.f_82481_);
    }

    public Vec3 getStartPos() {
        Vector3f vec = (Vector3f)this.f_19804_.m_135370_(START_POS);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public Vec3 getEndPos() {
        Vector3f vec = (Vector3f)this.f_19804_.m_135370_(END_POS);
        return new Vec3((double)vec.x(), (double)vec.y(), (double)vec.z());
    }

    public static void spawnRay(Level level, Vec3 start, Vec3 end) {
        RayEntity ray = new RayEntity((EntityType)SwordSoaringEntities.RAY_ENTITY.get(), level);
        ray.updatePositions(start, end);
        level.m_7967_((Entity)ray);
    }

    public static void updateRay(RayEntity entity, Vec3 newEnd) {
        Vec3 currentStart = entity.getStartPos();
        entity.updatePositions(currentStart, newEnd);
    }
}

