/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.p1nero.ss.entity.AbstractArtifactSpiritEntity;
import net.p1nero.ss.mixin.DodgeLocationIndicatorAccessor;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.DodgeLocationIndicator;

public abstract class AbstractArtifactSpiritPatch<T extends AbstractArtifactSpiritEntity>
extends MobPatch<T> {
    @Nullable
    private PlayerPatch<?> ownerPatch;

    public AbstractArtifactSpiritPatch() {
    }

    public AbstractArtifactSpiritPatch(Faction faction) {
        super(faction);
    }

    public void updateMotion(boolean considerInaction) {
        if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        } else {
            this.syncMotionToOwner(considerInaction);
        }
    }

    public void syncMotionToOwner(boolean considerInaction) {
        LivingEntity livingEntity = ((AbstractArtifactSpiritEntity)this.original).m_269323_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            PlayerPatch patch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            this.currentLivingMotion = patch.currentLivingMotion;
            this.currentCompositeMotion = patch.currentCompositeMotion;
        } else {
            this.currentLivingMotion = LivingMotions.IDLE;
            this.currentCompositeMotion = LivingMotions.IDLE;
        }
    }

    public void keepIdleMotion(boolean considerInaction) {
        this.currentLivingMotion = LivingMotions.IDLE;
        this.currentCompositeMotion = LivingMotions.IDLE;
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return null;
    }

    @Nullable
    public PlayerPatch<?> getOwnerPatch() {
        if (this.ownerPatch != null) {
            return this.ownerPatch;
        }
        if (((AbstractArtifactSpiritEntity)this.getOriginal()).m_269323_() != null) {
            this.ownerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)((AbstractArtifactSpiritEntity)this.getOriginal()).m_269323_(), PlayerPatch.class);
            return this.ownerPatch;
        }
        return null;
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        DodgeLocationIndicator dodgeLocationIndicator;
        if (target instanceof DodgeLocationIndicator && ((DodgeLocationIndicatorAccessor)(dodgeLocationIndicator = (DodgeLocationIndicator)target)).getLivingEntityPatch() == this.ownerPatch) {
            return AttackResult.missed((float)0.0f);
        }
        if (this.getOwnerPatch() != null && this.shouldUseOwnerAttack()) {
            return this.getOwnerPatch().attack(damageSource, target, hand);
        }
        return super.attack(damageSource, target, hand);
    }

    public boolean shouldUseOwnerAttack() {
        return true;
    }

    @Nullable
    public EpicFightDamageSource getEpicFightDamageSource() {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getEpicFightDamageSource();
        }
        return super.getEpicFightDamageSource();
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        if (this.getOwnerPatch() != null) {
            return this.getOwnerPatch().getDamageSource(animation, hand);
        }
        return super.getDamageSource(animation, hand);
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getSwingSound(hand);
        }
        return this.getOwnerPatch().getSwingSound(hand);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        if (this.getOwnerPatch() == null) {
            return super.getWeaponHitSound(hand);
        }
        return this.getOwnerPatch().getWeaponHitSound(hand);
    }

    public boolean isTargetInvulnerable(Entity entity) {
        if (entity.equals((Object)((AbstractArtifactSpiritEntity)this.getOriginal()).m_269323_())) {
            return true;
        }
        if (entity instanceof AbstractArtifactSpiritEntity) {
            AbstractArtifactSpiritEntity artifactSpiritEntity = (AbstractArtifactSpiritEntity)entity;
            if (this.getOwnerPatch() != null) {
                return ((Player)this.getOwnerPatch().getOriginal()).equals((Object)artifactSpiritEntity.m_269323_());
            }
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
        return false;
    }
}

