/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.entity;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.p1nero.ss.SwordSoaringMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class AbstractArtifactSpiritEntity
extends PathfinderMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNER_UUID = SynchedEntityData.m_135353_(AbstractArtifactSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public AbstractArtifactSpiritEntity(EntityType<? extends AbstractArtifactSpiritEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20331_(true);
        this.f_19811_ = true;
    }

    public boolean m_6072_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
    }

    @Nullable
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(pUuid));
    }

    public void tame(LivingEntity livingEntity) {
        this.setOwnerUUID(livingEntity.m_20148_());
    }

    @Nullable
    public LivingEntity m_269323_() {
        try {
            UUID uuid = this.m_21805_();
            if (uuid != null) {
                Player player = this.m_9236_().m_46003_(uuid);
                if (player == null) {
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        LivingEntity livingEntity;
                        ServerLevel serverLevel = (ServerLevel)level;
                        Entity entity = serverLevel.m_8791_(uuid);
                        return entity instanceof LivingEntity ? (livingEntity = (LivingEntity)entity) : null;
                    }
                } else {
                    return player;
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            SwordSoaringMod.LOGGER.error("error in get artifact spirit's owner", (Throwable)e);
            return null;
        }
    }

    public LivingEntityPatch<?> getOwnerPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.m_269323_(), LivingEntityPatch.class);
    }

    public LivingEntityPatch<?> getPatch() {
        return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this, LivingEntityPatch.class);
    }

    public <T extends EntityPatch<?>> T getPatch(Class<T> type) {
        return (T)EpicFightCapabilities.getEntityPatch((Entity)this, type);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19789_ = 0.0f;
        LivingEntity owner = this.m_269323_();
        if (owner != null && owner.m_6084_()) {
            this.moveToOwner(owner);
            if (this.getOriginalItem() == null) {
                return;
            }
            if (!this.m_9236_().f_46443_ && !owner.m_21205_().m_150930_(this.getOriginalItem()) && this.shouldRemoveWhenOwnerLost()) {
                this.m_146870_();
            }
        } else if (!this.m_9236_().f_46443_ && this.shouldRemoveWhenOwnerLost()) {
            this.m_146870_();
        }
    }

    protected void moveToOwner(LivingEntity owner) {
        if (!this.getOwnerPatch().getEntityState().lockonRotate()) {
            this.m_146922_(owner.f_20883_);
            this.m_5618_(owner.f_20883_);
            this.m_5616_(owner.f_20883_);
            this.m_146884_(owner.m_20182_());
        }
    }

    protected boolean shouldRemoveWhenOwnerLost() {
        return true;
    }

    @Nullable
    protected abstract Item getOriginalItem();

    public static AttributeSupplier getDefaultAttribute() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, (double)19.9f).m_22268_(Attributes.f_22281_, 3.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0).m_22265_();
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        return false;
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    public boolean m_5843_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }
}

