/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.compat.controlify;

import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.bind.ControlifyBindApi;
import dev.isxander.controlify.api.bind.InputBindingSupplier;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.entrypoint.InitContext;
import dev.isxander.controlify.api.entrypoint.PreInitContext;
import dev.isxander.controlify.bindings.BindContext;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.utils.render.Blit;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.p1nero.ss.SwordSoaringMod;
import net.p1nero.ss.client.keymapping.SwordSoaringKeyMappings;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class ControlifyCompat
implements ControlifyEntrypoint {
    private static InputBindingSupplier swordSkill;
    private static InputBindingSupplier takeOff;
    private static InputBindingSupplier toggleSoaringMode;
    private static InputBindingSupplier acceleration;
    private static InputBindingSupplier swordBack;
    private static final BindContext IN_GAME_EPIC_FIGHT_CONTEXT;

    public void onControllersDiscovered(ControlifyApi controlify) {
    }

    public void onControlifyInit(InitContext context) {
    }

    public void onControlifyPreInit(PreInitContext context) {
        ControlifyBindApi registrar = ControlifyBindApi.get();
        ControlifyCompat.registerCustomRadialIcons();
        registrar.registerBindContext(IN_GAME_EPIC_FIGHT_CONTEXT);
        ControlifyCompat.registerInputBindings(registrar);
    }

    private static void registerCustomRadialIcons() {
        for (SwordSoaringRadialIcons icon : SwordSoaringRadialIcons.values()) {
            ResourceLocation location = icon.getId();
            RadialIcons.registerIcon((ResourceLocation)location, (graphics, x, y, tickDelta) -> {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                Blit.blitTex((GuiGraphics)graphics, (ResourceLocation)location, (int)0, (int)0, (int)0, (int)0, (int)32, (int)32, (int)32, (int)32);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    private static void registerInputBindings(ControlifyBindApi registrar) {
        swordSkill = registrar.registerBinding(builder -> builder.id(SwordSoaringMod.rl("sword_skill")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SWORD_SKILL).description(ComponentConstants.SWORD_SKILL_DESCRIPTION).addKeyCorrelation(SwordSoaringKeyMappings.SWORD_SKILL).keyEmulation(SwordSoaringKeyMappings.SWORD_SKILL).radialCandidate(SwordSoaringRadialIcons.SCREEN_SWORD.getId()));
        takeOff = registrar.registerBinding(builder -> builder.id(SwordSoaringMod.rl("take_off")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.TAKE_OFF).description(ComponentConstants.TAKE_OFF_DESCRIPTION).addKeyCorrelation(SwordSoaringKeyMappings.TAKE_OFF).keyEmulation(SwordSoaringKeyMappings.TAKE_OFF));
        toggleSoaringMode = registrar.registerBinding(builder -> builder.id(SwordSoaringMod.rl("switch_mode")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SWITCH_MODE).description(ComponentConstants.SWITCH_MODE_DESCRIPTION).addKeyCorrelation(SwordSoaringKeyMappings.SWITCH_MODE).keyEmulation(SwordSoaringKeyMappings.SWITCH_MODE).radialCandidate(SwordSoaringRadialIcons.SWORD_SOARING_APPRENTICE.getId()));
        acceleration = registrar.registerBinding(builder -> builder.id(SwordSoaringMod.rl("acceleration")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.ACCELERATION).description(ComponentConstants.ACCELERATION_DESCRIPTION).addKeyCorrelation(SwordSoaringKeyMappings.ACCELERATION).keyEmulation(SwordSoaringKeyMappings.ACCELERATION));
        swordBack = registrar.registerBinding(builder -> builder.id(SwordSoaringMod.rl("sword_back")).category(ComponentConstants.COMMON_CATEGORY).allowedContexts(new BindContext[]{IN_GAME_EPIC_FIGHT_CONTEXT}).name(ComponentConstants.SWORD_BACK).description(ComponentConstants.SWORD_BACK_DESCRIPTION).addKeyCorrelation(SwordSoaringKeyMappings.SWORD_BACK).keyEmulation(SwordSoaringKeyMappings.SWORD_BACK).radialCandidate(SwordSoaringRadialIcons.VATANSEVER.getId()));
    }

    static {
        IN_GAME_EPIC_FIGHT_CONTEXT = new BindContext(SwordSoaringMod.rl("epicfight_combat"), mc -> {
            boolean isInGame = mc.f_91080_ == null && mc.f_91073_ != null && mc.f_91074_ != null;
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)mc.f_91074_, LocalPlayerPatch.class);
            if (localPlayerPatch == null) {
                return false;
            }
            return isInGame && localPlayerPatch.isEpicFightMode();
        });
    }

    private static enum SwordSoaringRadialIcons {
        SCREEN_SWORD(SwordSoaringMod.rl("textures/gui/skills/sword_controller/screen_sword.png")),
        VATANSEVER(SwordSoaringMod.rl("textures/item/vatansever.png")),
        SWORD_SOARING_APPRENTICE(SwordSoaringMod.rl("textures/gui/skills/sword_soaring/sword_soaring_apprentice.png"));

        @NotNull
        private final ResourceLocation id;

        private SwordSoaringRadialIcons(ResourceLocation id) {
            this.id = id;
        }

        @NotNull
        public ResourceLocation getId() {
            return this.id;
        }
    }

    private static class ComponentConstants {
        private static final Component COMMON_CATEGORY = Component.m_237115_((String)"key.sword_soaring.common");
        private static final Component SWORD_SKILL = Component.m_237115_((String)"key.sword_soaring.sword_skill");
        private static final Component SWORD_BACK = Component.m_237115_((String)"key.sword_soaring.sword_back");
        private static final Component TAKE_OFF = Component.m_237115_((String)"key.sword_soaring.take_off");
        private static final Component ACCELERATION = Component.m_237115_((String)"key.sword_soaring.acceleration");
        private static final Component SWITCH_MODE = Component.m_237115_((String)"key.sword_soaring.switch_mode");
        private static final Component SWORD_SKILL_DESCRIPTION = Component.m_237115_((String)"key.sword_soaring.sword_skill.description");
        private static final Component SWORD_BACK_DESCRIPTION = Component.m_237115_((String)"key.sword_soaring.sword_back.description");
        private static final Component TAKE_OFF_DESCRIPTION = Component.m_237115_((String)"key.sword_soaring.take_off.description");
        private static final Component ACCELERATION_DESCRIPTION = Component.m_237115_((String)"key.sword_soaring.acceleration.description");
        private static final Component SWITCH_MODE_DESCRIPTION = Component.m_237115_((String)"key.sword_soaring.switch_mode.description");

        private ComponentConstants() {
        }
    }
}

