/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.client;

import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.SwordSoaringSkillSlots;
import yesman.epicfight.api.client.camera.EpicFightCameraAPI;
import yesman.epicfight.api.client.event.types.BuildCameraTransform;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;

@Mod.EventBusSubscriber(modid="sword_soaring", value={Dist.CLIENT})
public class SwordSoaringCameraManager {
    public static final Vec3f DEFAULT_AIMING_CORRECTION;
    private static final double DEFAULT_CAMERA_ZOOM = 6.0;
    private static Vec3f aimingCorrection;
    private static final int MAX_ZOOM_TICK = 60;
    private static boolean zooming;
    private static int zoomOutTimer;
    private static int zoomTick;

    public static boolean isZooming() {
        return zoomTick <= 0;
    }

    public static boolean shouldAlignPlayerLookToCamera(LocalPlayerPatch localPlayerPatch) {
        SkillDataManager manager = localPlayerPatch.getSkill((SkillSlot)SwordSoaringSkillSlots.SWORD_SOARING).getDataManager();
        return SwordSoaringCameraManager.isZooming() || manager.hasData((SkillDataKey)SwordSoaringDatakeys.FLYING.get()) && (Boolean)manager.getDataValue((SkillDataKey)SwordSoaringDatakeys.FLYING.get()) != false;
    }

    public static void zoomIn(Vec3f aimingCorrection, int timer) {
        zooming = true;
        zoomTick = zoomTick == 0 ? 1 : zoomTick;
        zoomOutTimer = timer;
        SwordSoaringCameraManager.aimingCorrection = aimingCorrection;
        EpicFightCameraAPI.getInstance().setCouplingState(true);
    }

    public static void zoomIn(Vec3f aimingCorrection) {
        SwordSoaringCameraManager.zoomIn(aimingCorrection, 0);
    }

    public static void zoomOut() {
        zooming = false;
        zoomOutTimer = -1;
        EpicFightCameraAPI.getInstance().setCouplingState(false);
    }

    public static void zoomOut(int timer) {
        zoomOutTimer = timer;
    }

    public static void tick() {
        if (zoomTick > 0 && !Minecraft.m_91087_().m_91104_()) {
            zoomTick = zooming ? zoomTick + 1 : zoomTick - 1;
            zoomTick = Math.min(60, zoomTick);
            if (--zoomOutTimer < 0) {
                SwordSoaringCameraManager.zoomOut();
            }
        }
    }

    public static void onEpicFightCameraSetupEnd(BuildCameraTransform.Post event) {
        if (zoomTick > 0 && EpicFightCameraAPI.getInstance().isTPSMode()) {
            SwordSoaringCameraManager.setCameraAnimThirdPerson(event.getCameraApi().getCameraYRotO(), event.getCameraApi().getCameraYRot(), event.getCamera(), Minecraft.m_91087_().f_91066_.m_92176_(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    public static void onVanillaCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (zoomTick > 0 && !EpicFightCameraAPI.getInstance().isTPSMode()) {
            SwordSoaringCameraManager.setCameraAnimThirdPerson(event.getYaw(), event.getYaw(), event.getCamera(), Minecraft.m_91087_().f_91066_.m_92176_(), (float)event.getPartialTick());
        }
    }

    private static void setCameraAnimThirdPerson(float cameraYRotO, float cameraYRot, Camera camera, CameraType pov, float partialTick) {
        BlockPos cameraPos;
        Entity entity = Minecraft.m_91087_().m_91288_();
        if (entity == null) {
            return;
        }
        Vec3 vector = camera.m_90583_();
        double totalX = vector.m_7096_();
        double totalY = vector.m_7098_();
        double totalZ = vector.m_7094_();
        if (pov == CameraType.THIRD_PERSON_BACK) {
            double d3;
            double posX = vector.m_7096_();
            double posY = vector.m_7098_();
            double posZ = vector.m_7094_();
            double entityPosX = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialTick;
            double entityPosY = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialTick + (double)entity.m_20192_();
            double entityPosZ = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialTick;
            float intpol = (float)zoomTick / 60.0f;
            Vec3f interpolatedCorrection = new Vec3f(SwordSoaringCameraManager.aimingCorrection.x * intpol, SwordSoaringCameraManager.aimingCorrection.y * intpol, SwordSoaringCameraManager.aimingCorrection.z * intpol);
            OpenMatrix4f rotationMatrix = MathUtils.getModelMatrixIntegral((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)cameraYRotO, (float)cameraYRot, (float)partialTick, (float)0.9375f, (float)0.9375f, (float)0.9375f);
            Vec3f rotateVec = OpenMatrix4f.transform3v((OpenMatrix4f)rotationMatrix, (Vec3f)interpolatedCorrection, null);
            double smallest = d3 = Math.sqrt(rotateVec.x * rotateVec.x + rotateVec.y * rotateVec.y + rotateVec.z * rotateVec.z);
            double d00 = posX + (double)rotateVec.x;
            double d11 = posY - (double)rotateVec.y;
            double d22 = posZ + (double)rotateVec.z;
            for (int i = 0; i < 8; ++i) {
                BlockHitResult raytraceresult;
                double d7;
                float f = (i & 1) * 2 - 1;
                float f1 = (i >> 1 & 1) * 2 - 1;
                float f2 = (i >> 2 & 1) * 2 - 1;
                if (!((d7 = (raytraceresult = Minecraft.m_91087_().f_91073_.m_45547_(new ClipContext(new Vec3(entityPosX + (double)(f *= 0.1f), entityPosY + (double)(f1 *= 0.1f), entityPosZ + (double)(f2 *= 0.1f)), new Vec3(d00 + (double)f + (double)f2, d11 + (double)f1, d22 + (double)f2), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity))).m_82450_().m_82554_(new Vec3(entityPosX, entityPosY, entityPosZ))) < smallest)) continue;
                smallest = d7;
            }
            float dist = d3 == 0.0 ? 0.0f : (float)(smallest / d3);
            totalX += (double)(rotateVec.x * dist);
            totalY -= (double)(rotateVec.y * dist);
            totalZ += (double)(rotateVec.z * dist);
        }
        if (Minecraft.m_91087_().f_91073_.m_8055_(cameraPos = new BlockPos((int)totalX, (int)totalY, (int)totalZ)).m_60713_(Blocks.f_50016_)) {
            camera.m_90584_(totalX, totalY, totalZ);
        }
    }

    static {
        aimingCorrection = DEFAULT_AIMING_CORRECTION = new Vec3f(1.5f, 0.0f, 1.25f);
        zoomOutTimer = 0;
    }
}

