/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.p1nero.ss.SwordSoaringConfig;
import net.p1nero.ss.entity.sword.fly_sword.FlySwordEntity;
import net.p1nero.ss.network.PacketHandler;
import net.p1nero.ss.network.PacketRelay;
import net.p1nero.ss.network.packet.client.SyncBabylonPacket;
import net.p1nero.ss.util.ItemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;

public class SSPlayer {
    @Nullable
    private Skill lastDodgeSkill;
    private final Map<AttackAnimation.Phase, List<Entity>> phaseListMap = new HashMap<AttackAnimation.Phase, List<Entity>>();
    private final ArrayList<FlySwordEntity> vatanseverShootEntities = new ArrayList();
    private ArrayList<ItemStack> validBabylonItems = new ArrayList();
    private ArrayList<ItemStack> wanSwordList;

    public void setLastDodgeSkill(@Nullable Skill lastDodgeSkill) {
        this.lastDodgeSkill = lastDodgeSkill;
    }

    @Nullable
    public Skill getLastDodgeSkill() {
        return this.lastDodgeSkill;
    }

    public Map<AttackAnimation.Phase, List<Entity>> getPhaseListMap() {
        return this.phaseListMap;
    }

    public List<Entity> getCurrentlyHurtEntities(AttackAnimation.Phase phase) {
        List<Entity> toReturn = this.phaseListMap.get(phase);
        if (toReturn == null) {
            ArrayList<Entity> newList = new ArrayList<Entity>();
            this.phaseListMap.put(phase, newList);
            return newList;
        }
        return toReturn;
    }

    public void clearMap() {
        this.phaseListMap.clear();
    }

    public ArrayList<FlySwordEntity> getVatanseverShootEntities() {
        return this.vatanseverShootEntities;
    }

    public void addVatanseverShootEntity(@NotNull FlySwordEntity flySwordEntity) {
        this.vatanseverShootEntities.add(flySwordEntity);
    }

    public void clearVatanseverShootEntities() {
        Iterator<FlySwordEntity> iterator = this.vatanseverShootEntities.iterator();
        while (iterator.hasNext()) {
            FlySwordEntity flySwordEntity = iterator.next();
            if (flySwordEntity != null && flySwordEntity.m_6084_()) {
                flySwordEntity.m_146870_();
            }
            iterator.remove();
        }
    }

    public int initBabylonItems(ServerPlayer player) {
        this.validBabylonItems = ItemUtils.calculateValidBabylonItems(player, (Boolean)SwordSoaringConfig.REMOVE_ITEM.get());
        PacketRelay.sendToPlayer(PacketHandler.INSTANCE, new SyncBabylonPacket(player.m_19879_(), this.validBabylonItems.size(), this.validBabylonItems), player);
        return this.validBabylonItems.size();
    }

    public void updateBabylonItems(ArrayList<ItemStack> newItems) {
        this.validBabylonItems = newItems;
    }

    public ArrayList<ItemStack> getValidBabylonItems() {
        return this.validBabylonItems;
    }

    public void setWanSwordList(ArrayList<ItemStack> wanSwordList) {
        this.wanSwordList = wanSwordList;
    }

    public ArrayList<ItemStack> getWanSwordList() {
        return this.wanSwordList;
    }

    public void saveNBTData(CompoundTag tag) {
        if (this.lastDodgeSkill != null) {
            tag.m_128359_("last_dodge_skill", this.lastDodgeSkill.toString());
        }
    }

    public void loadNBTData(CompoundTag tag) {
        this.lastDodgeSkill = SkillManager.getSkill((String)tag.m_128461_("last_dodge_skill"));
    }

    public void copyFrom(SSPlayer old) {
        this.lastDodgeSkill = old.lastDodgeSkill;
    }
}

