/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.animation;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.entity.PartEntity;
import net.p1nero.ss.animation.ArtifactSpiritMultiPhaseAttackAnimation;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.entity.sword.gate_of_babylon.AbstractBabylonPatch;
import net.p1nero.ss.entity.sword.gate_of_babylon.BabylonEntity;
import net.p1nero.ss.entity.sword.wan.WanEntity;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class BabylonMultiPhaseAttackAnimation
extends ArtifactSpiritMultiPhaseAttackAnimation {
    public BabylonMultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public BabylonMultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
    }

    public BabylonMultiPhaseAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public BabylonMultiPhaseAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    @Override
    protected void hurtCollidingEntities(LivingEntityPatch<?> entityPatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        float poseTime;
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        List list = phase.getCollidingEntities(entityPatch, (AttackAnimation)this, prevPoseTime, poseTime = state.attacking() ? elapsedTime : phase.contact, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            AbstractBabylonPatch babylonPatch;
            HitEntityList hitEntities = new HitEntityList(entityPatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            if (entityPatch instanceof AbstractBabylonPatch && (babylonPatch = (AbstractBabylonPatch)entityPatch).getOwnerPatch() != null) {
                SSPlayer ssPlayer = (SSPlayer)((Player)babylonPatch.getOwnerPatch().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
                while (hitEntities.next()) {
                    Entity hit = hitEntities.getEntity();
                    LivingEntity trueEntity = this.getTrueEntity(hit);
                    if (trueEntity == null || !trueEntity.m_6084_() || ssPlayer.getCurrentlyHurtEntities(phase).contains(trueEntity) || trueEntity.m_7306_(babylonPatch.getOwnerPatch().getOriginal()) || trueEntity.m_7306_(babylonPatch.getOriginal()) || !(hit instanceof LivingEntity) && !(hit instanceof PartEntity)) continue;
                    EpicFightDamageSource source = this.getEpicFightDamageSource(entityPatch, hit, phase);
                    int prevInvulTime = hit.f_19802_;
                    hit.f_19802_ = 0;
                    double damage = ((BabylonEntity)babylonPatch.getOriginal()).getJointDamage((Joint)List.of(phase.colliders).get(0).getFirst());
                    if (entityPatch.getOriginal() instanceof WanEntity) {
                        damage = ((Player)babylonPatch.getOwnerPatch().getOriginal()).m_21133_(Attributes.f_22281_);
                    }
                    if (damage == 0.0) continue;
                    babylonPatch.setModifiedBaseDamage((float)damage);
                    AttackResult attackResult = entityPatch.attack(source, hit, phase.hand);
                    hit.f_19802_ = prevInvulTime;
                    if (attackResult.resultType.dealtDamage()) {
                        hit.m_9236_().m_6263_(null, hit.m_20185_(), hit.m_20186_(), hit.m_20189_(), this.getHitSound(entityPatch, phase), hit.m_5720_(), 1.0f, 1.0f);
                        this.spawnHitParticle((ServerLevel)hit.m_9236_(), entityPatch, hit, phase);
                    }
                    ssPlayer.getCurrentlyHurtEntities(phase).add((Entity)trueEntity);
                    if (!attackResult.resultType.shouldCount()) continue;
                    entityPatch.getCurrentlyAttackTriedEntities().add(trueEntity);
                }
            }
        }
    }
}

