/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss.animation;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.p1nero.ss.capability.SSCapabilityProvider;
import net.p1nero.ss.capability.SSPlayer;
import net.p1nero.ss.collider.WrappedCollider;
import net.p1nero.ss.entity.AbstractArtifactSpiritPatch;
import net.p1nero.ss.entity.sword.AbstractSwordEntity;
import net.p1nero.ss.gameassets.animations.ScreenSwordAnimations;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;

public class ArtifactSpiritMultiPhaseAttackAnimation
extends AttackAnimation {
    public ArtifactSpiritMultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
    }

    public ArtifactSpiritMultiPhaseAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
    }

    public ArtifactSpiritMultiPhaseAttackAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends AttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
    }

    public ArtifactSpiritMultiPhaseAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, path, armature);
    }

    public void begin(LivingEntityPatch<?> entityPatch) {
        AbstractArtifactSpiritPatch artifactSpiritPatch;
        super.begin(entityPatch);
        if (entityPatch instanceof AbstractArtifactSpiritPatch && (artifactSpiritPatch = (AbstractArtifactSpiritPatch)entityPatch).getOwnerPatch() != null) {
            ((Player)artifactSpiritPatch.getOwnerPatch().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).ifPresent(SSPlayer::clearMap);
        }
    }

    public boolean isPhaseValid(LivingEntityPatch<?> entityPatch, AttackAnimation.Phase phase) {
        return true;
    }

    protected void attackTick(LivingEntityPatch<?> entityPatch, AssetAccessor<? extends DynamicAnimation> animation) {
        super.attackTick(entityPatch, animation);
        AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(animation);
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entityPatch, elapsedTime);
        EntityState prevState = this.getState(entityPatch, prevElapsedTime);
        for (AttackAnimation.Phase phase : this.phases) {
            if (!this.isPhaseValid(entityPatch, phase) || !(phase instanceof MultiAttackPhase)) continue;
            MultiAttackPhase multiAttackPhase = (MultiAttackPhase)phase;
            if (!prevState.attacking() && !state.attacking() && (prevState.getLevel() >= 2 || state.getLevel() <= 2)) continue;
            this.hurtCollidingEntities(entityPatch, prevElapsedTime, elapsedTime, prevState, state, multiAttackPhase);
        }
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entityPatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        float poseTime;
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        List list = phase.getCollidingEntities(entityPatch, (AttackAnimation)this, prevPoseTime, poseTime = state.attacking() ? elapsedTime : phase.contact, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            AbstractArtifactSpiritPatch artifactSpiritPatch;
            HitEntityList hitEntities = new HitEntityList(entityPatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            if (entityPatch instanceof AbstractArtifactSpiritPatch && (artifactSpiritPatch = (AbstractArtifactSpiritPatch)entityPatch).getOwnerPatch() != null) {
                SSPlayer ssPlayer = (SSPlayer)((Player)artifactSpiritPatch.getOwnerPatch().getOriginal()).getCapability(SSCapabilityProvider.SS_PLAYER).orElse((Object)new SSPlayer());
                while (hitEntities.next()) {
                    Entity hit = hitEntities.getEntity();
                    LivingEntity trueEntity = this.getTrueEntity(hit);
                    if (trueEntity == null || !trueEntity.m_6084_() || ssPlayer.getCurrentlyHurtEntities(phase).contains(trueEntity) || trueEntity.m_7306_(artifactSpiritPatch.getOwnerPatch().getOriginal()) || trueEntity.m_7306_(artifactSpiritPatch.getOriginal()) || !(hit instanceof LivingEntity) && !(hit instanceof PartEntity)) continue;
                    EpicFightDamageSource source = this.getEpicFightDamageSource(entityPatch, hit, phase);
                    int prevInvulTime = hit.f_19802_;
                    hit.f_19802_ = 0;
                    AttackResult attackResult = entityPatch.attack(source, hit, phase.hand);
                    hit.f_19802_ = prevInvulTime;
                    if (attackResult.resultType.dealtDamage()) {
                        if (this.equals(ScreenSwordAnimations.KILL_AURA_2.get())) {
                            trueEntity.m_20254_(5);
                        }
                        hit.m_9236_().m_6263_(null, hit.m_20185_(), hit.m_20186_(), hit.m_20189_(), this.getHitSound(entityPatch, phase), hit.m_5720_(), 1.0f, 1.0f);
                        this.spawnHitParticle((ServerLevel)hit.m_9236_(), entityPatch, hit, phase);
                    }
                    ssPlayer.getCurrentlyHurtEntities(phase).add((Entity)trueEntity);
                    if (!attackResult.resultType.shouldCount()) continue;
                    entityPatch.getCurrentlyAttackTriedEntities().add(trueEntity);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entityPatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = entityPatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        for (AttackAnimation.Phase phase : this.phases) {
            if (!this.isPhaseValid(entityPatch, phase)) continue;
            boolean flag = false;
            ArrayList<AttackAnimation.JointColliderPair> newColliders = new ArrayList<AttackAnimation.JointColliderPair>();
            Iterator iterator = Arrays.stream(phase.colliders).iterator();
            while (iterator.hasNext()) {
                Pair colliderInfo = (Pair)iterator.next();
                WrappedCollider<Collider> collider = (WrappedCollider<Collider>)((Object)colliderInfo.getSecond());
                Entity entity = entityPatch.getOriginal();
                if (entity instanceof AbstractSwordEntity) {
                    AbstractSwordEntity swordEntity = (AbstractSwordEntity)entity;
                    ItemStack stack = swordEntity.getItemStack(entityPatch);
                    WrappedCollider<Collider> newCollider = new WrappedCollider<Collider>(EpicFightCapabilities.getItemStackCapability((ItemStack)stack).getWeaponCollider());
                    if (!((Object)newCollider).equals(colliderInfo.getSecond())) {
                        flag = true;
                        collider = newCollider;
                    }
                    newColliders.add(AttackAnimation.JointColliderPair.of((Joint)((Joint)colliderInfo.getFirst()), collider));
                }
                collider.draw(poseStack, buffer, entityPatch, this, (Joint)colliderInfo.getFirst(), prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entityPatch, (DynamicAnimation)this));
            }
            if (!flag) continue;
            phase.colliders = newColliders.toArray(new AttackAnimation.JointColliderPair[0]);
        }
    }

    public static class MultiAttackPhase
    extends AttackAnimation.Phase {
        public MultiAttackPhase(float start, float antic, float contact, float recovery, float end, Joint joint, Collider collider) {
            super(start, antic, contact, recovery, end, joint, collider);
        }

        public MultiAttackPhase(float start, float antic, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            super(start, antic, contact, recovery, end, hand, joint, collider);
        }

        public MultiAttackPhase(float start, float antic, float preDelay, float contact, float recovery, float end, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, joint, collider);
        }

        public MultiAttackPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
        }

        public MultiAttackPhase(InteractionHand hand, Joint joint, Collider collider) {
            super(hand, joint, collider);
        }

        public MultiAttackPhase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, Joint joint, Collider collider) {
            super(start, antic, preDelay, contact, recovery, end, noStateBind, hand, joint, collider);
        }

        public MultiAttackPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, hand, colliders);
        }

        public MultiAttackPhase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, AttackAnimation.JointColliderPair ... colliders) {
            super(start, antic, preDelay, contact, recovery, end, noStateBind, hand, colliders);
        }

        public List<Entity> getCollidingEntities(LivingEntityPatch<?> entityPatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float attackSpeed) {
            Entity entity = entityPatch.getOriginal();
            if (entity instanceof AbstractSwordEntity) {
                AbstractSwordEntity swordEntity = (AbstractSwordEntity)entity;
                ArrayList entities = Lists.newArrayList();
                boolean flag = false;
                ArrayList<AttackAnimation.JointColliderPair> newColliders = new ArrayList<AttackAnimation.JointColliderPair>();
                Iterator iterator = Arrays.stream(this.colliders).iterator();
                while (iterator.hasNext()) {
                    Pair colliderInfo = (Pair)iterator.next();
                    WrappedCollider<Collider> collider = (WrappedCollider<Collider>)((Object)colliderInfo.getSecond());
                    ItemStack stack = swordEntity.getItemStack(entityPatch);
                    WrappedCollider<Collider> newCollider = new WrappedCollider<Collider>(EpicFightCapabilities.getItemStackCapability((ItemStack)stack).getWeaponCollider());
                    if (!((Object)newCollider).equals(colliderInfo.getSecond())) {
                        flag = true;
                        collider = newCollider;
                        newColliders.add(AttackAnimation.JointColliderPair.of((Joint)((Joint)colliderInfo.getFirst()), collider));
                    }
                    entities.addAll(collider.updateAndSelectCollideEntity(entityPatch, animation, prevElapsedTime, elapsedTime, (Joint)colliderInfo.getFirst(), attackSpeed));
                }
                if (flag) {
                    this.colliders = newColliders.toArray(new AttackAnimation.JointColliderPair[0]);
                }
                return entities;
            }
            return super.getCollidingEntities(entityPatch, animation, prevElapsedTime, elapsedTime, attackSpeed);
        }
    }
}

