/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss;

import com.merlin204.avalon.item.IChangeArmatureItem;
import com.merlin204.avalon.item.animationitem.IAvalonAnimationItem;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.api.skill.ComboType;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.p1nero.ss.SwordSoaringConfig;
import net.p1nero.ss.client.particle.SwordSoaringParticles;
import net.p1nero.ss.client.sound.SwordSoaringSounds;
import net.p1nero.ss.compat.EpicSkillsCompat;
import net.p1nero.ss.entity.SwordSoaringEntities;
import net.p1nero.ss.gameassets.SwordSoaringComboTypes;
import net.p1nero.ss.gameassets.SwordSoaringDatakeys;
import net.p1nero.ss.gameassets.SwordSoaringSkillCategories;
import net.p1nero.ss.gameassets.SwordSoaringSkillSlots;
import net.p1nero.ss.gameassets.SwordSoaringWeaponCategories;
import net.p1nero.ss.item.SwordSoaringItems;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

@Mod(value="sword_soaring")
public class SwordSoaringMod {
    public static final String MOD_ID = "sword_soaring";
    public static final Logger LOGGER = LogUtils.getLogger();

    public SwordSoaringMod(FMLJavaModLoadingContext context) {
        SkillCategories.ENUM_MANAGER.registerEnumCls(MOD_ID, SwordSoaringSkillCategories.class);
        SkillSlot.ENUM_MANAGER.registerEnumCls(MOD_ID, SwordSoaringSkillSlots.class);
        CapabilityItem.WeaponCategories.ENUM_MANAGER.registerEnumCls(MOD_ID, SwordSoaringWeaponCategories.class);
        ComboType.ENUM_MANAGER.registerEnumCls(MOD_ID, SwordSoaringComboTypes.class);
        if (EpicFightSharedConstants.isPhysicalClient() && ModList.get().isLoaded("epicskills")) {
            EpicSkillsCompat.registerCategorySlotTexture();
        }
        IEventBus bus = context.getModEventBus();
        SwordSoaringDatakeys.DATA_KEYS.register(bus);
        SwordSoaringItems.ITEMS.register(bus);
        SwordSoaringItems.SWORD_SOARING_ITEM_TAB.register(bus);
        SwordSoaringEntities.ENTITIES.register(bus);
        SwordSoaringSounds.SOUND_EVENTS.register(bus);
        SwordSoaringParticles.PARTICLES.register(bus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SwordSoaringConfig.SPEC);
    }

    public static boolean isArmourersWorkshopLoaded() {
        return ModList.get().isLoaded("armourers_workshop");
    }

    public static boolean isValidSword(ItemStack sword) {
        if (SwordSoaringConfig.swordItems.isEmpty()) {
            SwordSoaringConfig.swordItems = ((List)SwordSoaringConfig.ITEMS_CAN_FLY.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
            SwordSoaringConfig.notSwordItems = ((List)SwordSoaringConfig.ITEMS_CAN_NOT_FLY.get()).stream().map(itemName -> (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemName))).collect(Collectors.toSet());
            if (ModList.get().isLoaded("epic_fight_avalon")) {
                ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof IAvalonAnimationItem || item instanceof IChangeArmatureItem).forEach(item -> SwordSoaringConfig.notSwordItems.add((Item)item));
            }
        }
        if (SwordSoaringConfig.notSwordItems.contains(sword.m_41720_())) {
            return false;
        }
        return sword.m_41720_() instanceof SwordItem || SwordSoaringConfig.swordItems.contains(sword.m_41720_());
    }

    public static void runInArmourersWorkshopLoaded(Supplier<Runnable> handler) {
        if (SwordSoaringMod.isArmourersWorkshopLoaded()) {
            handler.get().run();
        }
    }

    @NotNull
    public static ResourceLocation rl(@NotNull String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }
}

