/*
 * Decompiled with CFR 0.152.
 */
package net.p1nero.ss;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="sword_soaring", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SwordSoaringConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_CAN_FLY;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_CAN_NOT_FLY;
    public static final ForgeConfigSpec.IntValue FLY_DELAY;
    public static final ForgeConfigSpec.BooleanValue ITEMS_BLOOM;
    public static final ForgeConfigSpec.BooleanValue REMOVE_ITEM;
    public static final ForgeConfigSpec.IntValue SWORD_EFFECT_PER_TICK;
    public static final ForgeConfigSpec.IntValue WAN_TRAIL_UPDATE_TICK;
    public static final ForgeConfigSpec.ConfigValue<String> TRAIL_PARTICLE_TYPE;
    static final ForgeConfigSpec SPEC;
    public static Set<Item> swordItems;
    public static Set<Item> notSwordItems;

    private static ForgeConfigSpec.BooleanValue createBool(String key, boolean defaultValue, String ... comment) {
        return BUILDER.comment(comment).translation("config.sword_soaring." + key).define(key, defaultValue);
    }

    private static ForgeConfigSpec.DoubleValue createDouble(String key, double defaultValue, String ... comment) {
        return BUILDER.comment(comment).translation("config.sword_soaring." + key).defineInRange(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    private static ForgeConfigSpec.IntValue createInt(String key, int defaultValue, String ... comment) {
        return BUILDER.comment(comment).translation("config.sword_soaring." + key).defineInRange(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && ForgeRegistries.ITEMS.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }

    static {
        BUILDER.push("Sword Properties \u5251\u914d\u7f6e");
        ITEMS_CAN_FLY = BUILDER.comment(new String[]{"A list of items considered as sword.", "\u88ab\u89c6\u4e3a\u5251\u7684\u7269\u54c1"}).defineListAllowEmpty(List.of("items_considered_as_sword"), List::of, SwordSoaringConfig::validateItemName);
        ITEMS_CAN_NOT_FLY = BUILDER.comment(new String[]{"A list of items not considered as sword.", "\u4e0d\u88ab\u89c6\u4e3a\u5251\u7684\u7269\u54c1"}).defineListAllowEmpty(List.of("items_not_considered_as_sword"), () -> List.of("sword_soaring:vatansever"), SwordSoaringConfig::validateItemName);
        BUILDER.push("Sword Soaring \u5fa1\u5251\u51cc\u865a");
        FLY_DELAY = SwordSoaringConfig.createInt("fly_delay", 200, "time mills between double click of starting flying", "\u8d77\u98de\u7684\u53cc\u51fb\u95f4\u9694\u7684\u6beb\u79d2\u6570");
        BUILDER.pop();
        BUILDER.push("Gate of Babylon Skill \u738b\u4e4b\u8d22\u5b9d");
        ITEMS_BLOOM = SwordSoaringConfig.createBool("items_bloom", false, "should the item shot glowing", "\u53d1\u5c04\u7684\u7269\u54c1\u662f\u5426\u53d1\u5149");
        REMOVE_ITEM = SwordSoaringConfig.createBool("remove_item", false, "BE CAREFUL TO CHANGE!! remove the item in backpack and spawn when shot", "\u3010\u614e\u91cd\u542f\u7528\uff01\u3011\u53d1\u5c04\u7269\u54c1\u65f6\u662f\u5426\u5220\u9664\u80cc\u5305\u5185\u7684\u7269\u54c1\uff0c\u5e76\u5728\u5c04\u51fa\u53bb\u540e\u6389\u843d\u3002\u82e5\u6709\u9057\u5931\u6982\u4e0d\u8d1f\u8d23\u3002");
        BUILDER.pop();
        BUILDER.push("Sword Convergence \u4e07\u5251\u5f52\u5b97");
        SWORD_EFFECT_PER_TICK = SwordSoaringConfig.createInt("sword_effect_per_tick", 4, "additional swords per tick", "\u6bcf\u79d2\u805a\u96c6\u7684\u5251\u6570\uff08\u4ec5\u7279\u6548\uff09");
        WAN_TRAIL_UPDATE_TICK = SwordSoaringConfig.createInt("wan_trail_update_tick", 0, "trail effect update interval", "\u5200\u5149\u5237\u65b0\u9891\u7387\uff0c0\u4e3a\u5173\u95ed");
        TRAIL_PARTICLE_TYPE = BUILDER.comment(new String[]{"default trail particle type", "\u9ed8\u8ba4\u5200\u5149\u7c7b\u578b"}).define("trail_particle_type", (Object)"epicfight:swing_trail");
        BUILDER.pop();
        SPEC = BUILDER.build();
        swordItems = new HashSet<Item>();
        notSwordItems = new HashSet<Item>();
    }
}

