/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.world.biome.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.random.Weight;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;

public record AddCostedSpawnsBiomeModifier(EntityType<? extends Entity> entityType, List<CostSpawnerData> spawnerData) implements BiomeModifier
{
    public static final Codec<AddCostedSpawnsBiomeModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entityType").forGetter(AddCostedSpawnsBiomeModifier::entityType), (App)CostSpawnerData.LIST_CODEC.fieldOf("spawns").forGetter(AddCostedSpawnsBiomeModifier::spawnerData)).apply((Applicative)builder, AddCostedSpawnsBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (CostSpawnerData costSpawnerData : this.spawnerData) {
                if (!costSpawnerData.biomes().m_203333_(biome)) continue;
                spawns.m_48376_(costSpawnerData.category, new MobSpawnSettings.SpawnerData(this.entityType, costSpawnerData.weight, costSpawnerData.min, costSpawnerData.max));
                if (!(costSpawnerData.cost > 0.0) || !(costSpawnerData.budget > 0.0)) continue;
                spawns.m_48370_(this.entityType, costSpawnerData.cost, costSpawnerData.budget);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }

    private record CostSpawnerData(HolderSet<Biome> biomes, MobCategory category, Weight weight, int min, int max, double cost, double budget) {
        private static final Codec<CostSpawnerData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(CostSpawnerData::biomes), (App)MobCategory.f_21584_.fieldOf("category").forGetter(CostSpawnerData::category), (App)Weight.f_146274_.fieldOf("weight").forGetter(CostSpawnerData::weight), (App)Codec.INT.fieldOf("min").forGetter(CostSpawnerData::min), (App)Codec.INT.fieldOf("max").forGetter(CostSpawnerData::max), (App)Codec.DOUBLE.optionalFieldOf("cost", (Object)0.0).forGetter(CostSpawnerData::cost), (App)Codec.DOUBLE.optionalFieldOf("budget", (Object)0.0).forGetter(CostSpawnerData::budget)).apply((Applicative)builder, CostSpawnerData::new));
        private static final Codec<List<CostSpawnerData>> LIST_CODEC = CODEC.listOf();
    }
}

