/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.init;

import com.cgessinger.creaturesandbeasts.init.CNBParticleTypes;
import com.cgessinger.creaturesandbeasts.util.MinipadType;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CNBMinipadTypes {
    private static final List<MinipadType> MINIPAD_TYPES = new ArrayList<MinipadType>(3);
    public static final MinipadType LIGHT_PINK = CNBMinipadTypes.registerWithCNBDirectory("cnb", "light_pink", CNBParticleTypes.LIGHT_PINK_MINIPAD_FLOWER);
    public static final MinipadType PINK = CNBMinipadTypes.registerWithCNBDirectory("cnb", "pink", CNBParticleTypes.PINK_MINIPAD_FLOWER);
    public static final MinipadType YELLOW = CNBMinipadTypes.registerWithCNBDirectory("cnb", "yellow", CNBParticleTypes.YELLOW_MINIPAD_FLOWER);

    private static MinipadType registerWithCNBDirectory(String namespace, String name, Supplier<SimpleParticleType> particle) {
        return CNBMinipadTypes.registerWithCNBDirectory(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, name + "_minipad_flower")), () -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, name + "_minipad_flower_glow")), namespace, name, particle);
    }

    private static MinipadType registerWithCNBDirectory(@Nullable Item shearItem, @Nullable Item glowShearItem, String namespace, String name, Supplier<SimpleParticleType> particle) {
        return CNBMinipadTypes.registerWithCNBDirectory(() -> shearItem, () -> glowShearItem, namespace, name, particle);
    }

    private static MinipadType registerWithCNBDirectory(@Nullable Supplier<Item> shearItem, @Nullable Supplier<Item> glowShearItem, String namespace, String name, Supplier<SimpleParticleType> particle) {
        return CNBMinipadTypes.register(new MinipadType(shearItem, glowShearItem, new ResourceLocation(namespace, name), (Pair<ResourceLocation, ResourceLocation>)Pair.of((Object)new ResourceLocation("cnb", "textures/entity/minipad/minipad_" + name + ".png"), (Object)new ResourceLocation("cnb", "textures/entity/minipad/minipad_" + name + "_glow.png")), particle));
    }

    private static MinipadType register(MinipadType minipadType) {
        MINIPAD_TYPES.add(minipadType);
        return minipadType;
    }

    public static void registerAll() {
        for (MinipadType minipadType : MINIPAD_TYPES) {
            MinipadType.registerMinipadType(minipadType);
        }
    }
}

