/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.init;

import com.cgessinger.creaturesandbeasts.util.LilytadType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CNBLilytadTypes {
    private static final List<LilytadType> LILYTAD_TYPES = new ArrayList<LilytadType>(3);
    public static final LilytadType LIGHT_PINK = CNBLilytadTypes.registerWithCNBDirectory("cnb", "light_pink");
    public static final LilytadType PINK = CNBLilytadTypes.registerWithCNBDirectory("cnb", "pink");
    public static final LilytadType YELLOW = CNBLilytadTypes.registerWithCNBDirectory("cnb", "yellow");

    private static LilytadType registerWithCNBDirectory(String namespace, String name) {
        return CNBLilytadTypes.registerWithCNBDirectory(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(namespace, name + "_waterlily")), namespace, name);
    }

    private static LilytadType registerWithCNBDirectory(@Nullable Item shearItem, String namespace, String name) {
        return CNBLilytadTypes.registerWithCNBDirectory(() -> shearItem, namespace, name);
    }

    private static LilytadType registerWithCNBDirectory(@Nullable Supplier<Item> shearItem, String namespace, String name) {
        return CNBLilytadTypes.register(new LilytadType(shearItem, new ResourceLocation(namespace, name), new ResourceLocation("cnb", "textures/entity/lilytad/lilytad_" + name + ".png")));
    }

    private static LilytadType register(LilytadType lilytadType) {
        LILYTAD_TYPES.add(lilytadType);
        return lilytadType;
    }

    public static void registerAll() {
        for (LilytadType lilytadType : LILYTAD_TYPES) {
            LilytadType.registerLilytadType(lilytadType);
        }
    }
}

