/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.events;

import com.cgessinger.creaturesandbeasts.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.entities.CactemEntity;
import com.cgessinger.creaturesandbeasts.entities.CindershellEntity;
import com.cgessinger.creaturesandbeasts.entities.EndWhaleEntity;
import com.cgessinger.creaturesandbeasts.entities.LilytadEntity;
import com.cgessinger.creaturesandbeasts.entities.LittleGrebeEntity;
import com.cgessinger.creaturesandbeasts.entities.LizardEntity;
import com.cgessinger.creaturesandbeasts.entities.MinipadEntity;
import com.cgessinger.creaturesandbeasts.entities.SporelingEntity;
import com.cgessinger.creaturesandbeasts.entities.ThrownCactemSpearEntity;
import com.cgessinger.creaturesandbeasts.entities.YetiEntity;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.items.HealSpellBookItem;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cnb", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CNBEvents {
    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)CNBEntityTypes.CINDERSHELL.get(), CindershellEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.SPORELING.get(), SporelingEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.LITTLE_GREBE.get(), LittleGrebeEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.LILYTAD.get(), LilytadEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.LIZARD.get(), LizardEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.YETI.get(), YetiEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.MINIPAD.get(), MinipadEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.END_WHALE.get(), EndWhaleEntity.createAttributes().m_22265_());
        event.put((EntityType)CNBEntityTypes.CACTEM.get(), CactemEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Entity entity;
        Player player = event.getEntity();
        if (player.m_36341_() && (entity = player.m_146895_()) instanceof SporelingEntity) {
            SporelingEntity sporelingEntity = (SporelingEntity)entity;
            sporelingEntity.m_8127_();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLootingCalculate(LootingLevelEvent event) {
        DamageSource damageSource = event.getDamageSource();
        if (damageSource == null) {
            return;
        }
        Entity entity = damageSource.m_7640_();
        if (entity instanceof ThrownCactemSpearEntity) {
            ThrownCactemSpearEntity thrownSpear = (ThrownCactemSpearEntity)entity;
            int lootingLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44982_, (ItemStack)thrownSpear.getSpear());
            event.setLootingLevel(lootingLevel);
        }
    }

    @SubscribeEvent
    public void onItemUnequip(LivingEvent.LivingTickEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (livingEntity = (player = (Player)livingEntity).m_146895_()) instanceof SporelingEntity) {
            SporelingEntity sporelingEntity = (SporelingEntity)livingEntity;
            if (!player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)CNBItems.SPORELING_BACKPACK.get())) {
                sporelingEntity.m_8127_();
            }
        }
    }

    @SubscribeEvent
    public void onItemAttributeModifierCalculate(ItemAttributeModifierEvent event) {
        ItemStack input = event.getItemStack();
        CompoundTag tag = input.m_41783_();
        EquipmentSlot equipmentSlot = null;
        if (input.m_41720_() instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)input.m_41720_();
            equipmentSlot = armorItem.m_40402_();
        }
        if (equipmentSlot != null && tag != null && event.getSlotType().equals((Object)equipmentSlot) && tag.m_128441_("HideAmount")) {
            int hideAmount = tag.m_128451_("HideAmount");
            if (equipmentSlot.equals((Object)EquipmentSlot.HEAD)) {
                event.addModifier(Attributes.f_22284_, new AttributeModifier(UUID.fromString("96a6b318-81f1-475a-b4a4-b3da41d2711e"), "yeti_hide", CNBConfig.hideMultiplier * (double)hideAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
            } else if (equipmentSlot.equals((Object)EquipmentSlot.CHEST)) {
                event.addModifier(Attributes.f_22284_, new AttributeModifier(UUID.fromString("3f3136ff-4f04-4d62-a9cc-8d1f4175c1e2"), "yeti_hide", CNBConfig.hideMultiplier * (double)hideAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
            } else if (equipmentSlot.equals((Object)EquipmentSlot.LEGS)) {
                event.addModifier(Attributes.f_22284_, new AttributeModifier(UUID.fromString("f49d078c-2740-4283-8255-5d1f106efea0"), "yeti_hide", CNBConfig.hideMultiplier * (double)hideAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
            } else {
                event.addModifier(Attributes.f_22284_, new AttributeModifier(UUID.fromString("b16e7c3f-508d-461d-8868-de6ee2a1314c"), "yeti_hide", CNBConfig.hideMultiplier * (double)hideAmount, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (event.getLeft().m_41720_() instanceof ArmorItem && event.getRight().m_150930_((Item)CNBItems.YETI_HIDE.get())) {
            ItemStack output = event.getLeft().m_41777_();
            CompoundTag nbt = output.m_41784_();
            int hideAmount = 1;
            if (nbt.m_128441_("HideAmount") && (hideAmount += nbt.m_128451_("HideAmount")) > CNBConfig.hideAmount) {
                return;
            }
            nbt.m_128405_("HideAmount", hideAmount);
            event.setCost(CNBConfig.hideCost);
            event.setMaterialCost(1);
            event.setOutput(output);
        } else if (event.getLeft().m_41720_() instanceof HealSpellBookItem && event.getRight().m_41720_() instanceof HealSpellBookItem && event.getLeft().m_150930_(event.getRight().m_41720_())) {
            int cost;
            ItemStack output;
            if (event.getLeft().m_150930_((Item)CNBItems.HEAL_SPELL_BOOK_1.get())) {
                output = new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_2.get());
                cost = 3;
            } else if (event.getLeft().m_150930_((Item)CNBItems.HEAL_SPELL_BOOK_2.get())) {
                output = new ItemStack((ItemLike)CNBItems.HEAL_SPELL_BOOK_3.get());
                cost = 6;
            } else {
                return;
            }
            output.m_41751_(event.getLeft().m_41784_());
            event.setCost(cost);
            event.setOutput(output);
            event.setMaterialCost(1);
        }
    }
}

