/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.MinipadEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.phys.Vec3;

class MinipadRandomStrollGoal
extends RandomStrollGoal {
    private final MinipadEntity minipad;
    private final int intervalLand;
    private final int intervalWater;
    private final boolean checkNoActionTime;

    public MinipadRandomStrollGoal(MinipadEntity minipad, double speedModifier) {
        this(minipad, speedModifier, 60, 120);
    }

    public MinipadRandomStrollGoal(MinipadEntity minipad, double speedModifier, int intervalLand, int intervalWater) {
        this(minipad, speedModifier, intervalLand, intervalWater, true);
    }

    public MinipadRandomStrollGoal(MinipadEntity minipad, double speedModifier, int intervalLand, int intervalWater, boolean checkNoActionTime) {
        super((PathfinderMob)minipad, speedModifier, intervalLand, checkNoActionTime);
        this.minipad = minipad;
        this.intervalLand = intervalLand;
        this.intervalWater = intervalWater;
        this.checkNoActionTime = checkNoActionTime;
    }

    public void m_8056_() {
        this.minipad.m_21573_().m_26519_(this.f_25726_, this.f_25727_, this.f_25728_, this.f_25729_);
    }

    public boolean m_8036_() {
        Vec3 vec3;
        if (this.f_25725_.m_20160_()) {
            return false;
        }
        if (!this.f_25731_) {
            int i;
            if (this.checkNoActionTime && this.f_25725_.m_21216_() >= 100) {
                return false;
            }
            int n = i = this.minipad.m_20069_() ? this.intervalWater : this.intervalLand;
            if (this.f_25725_.m_217043_().m_188503_(MinipadRandomStrollGoal.m_186073_((int)i)) != 0) {
                return false;
            }
        }
        if ((vec3 = this.m_7037_()) == null) {
            return false;
        }
        this.f_25726_ = vec3.f_82479_;
        this.f_25727_ = vec3.f_82480_;
        this.f_25728_ = vec3.f_82481_;
        this.f_25731_ = false;
        return true;
    }

    protected Vec3 m_7037_() {
        boolean flag = GoalUtils.m_148442_((PathfinderMob)this.minipad, (int)10);
        Vec3 vec3 = RandomPos.m_148542_((PathfinderMob)this.minipad, () -> {
            BlockPos blockpos = RandomPos.m_217851_((RandomSource)this.minipad.m_217043_(), (int)10, (int)7);
            return MinipadRandomStrollGoal.generateRandomPosTowardDirection(this.minipad, 10, flag, blockpos);
        });
        return vec3;
    }

    @Nullable
    private static BlockPos generateRandomPosTowardDirection(MinipadEntity minipad, int horizontalRange, boolean flag, BlockPos posTowards) {
        BlockPos blockpos = RandomPos.m_217863_((PathfinderMob)minipad, (int)horizontalRange, (RandomSource)minipad.m_217043_(), (BlockPos)posTowards);
        return !GoalUtils.m_148451_((BlockPos)blockpos, (PathfinderMob)minipad) && !GoalUtils.m_148454_((boolean)flag, (PathfinderMob)minipad, (BlockPos)blockpos) && !GoalUtils.m_148458_((PathfinderMob)minipad, (BlockPos)blockpos) && (!GoalUtils.m_148448_((PathNavigation)minipad.m_21573_(), (BlockPos)blockpos) || GoalUtils.m_148445_((PathfinderMob)minipad, (BlockPos)blockpos)) ? blockpos : null;
    }
}

