/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.entities;

import com.cgessinger.creaturesandbeasts.entities.MinipadFloatGoal;
import com.cgessinger.creaturesandbeasts.entities.MinipadPanicGoal;
import com.cgessinger.creaturesandbeasts.entities.MinipadRandomStrollGoal;
import com.cgessinger.creaturesandbeasts.entities.MinipadTryFindWaterGoal;
import com.cgessinger.creaturesandbeasts.init.CNBMinipadTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.util.MinipadType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.IForgeShearable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MinipadEntity
extends Animal
implements IForgeShearable,
GeoAnimatable {
    public static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(MinipadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(MinipadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> GLOWING = SynchedEntityData.m_135353_(MinipadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int shearedTimer = 0;

    public MinipadEntity(EntityType<? extends Animal> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
                if (MinipadEntity.this.shouldLookAround()) {
                    super.m_8128_();
                }
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)CNBMinipadTypes.PINK.getId().toString());
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(GLOWING, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        MinipadType type = MinipadType.getById(compound.m_128461_("MinipadType"));
        if (type == null) {
            type = CNBMinipadTypes.PINK;
        }
        this.setMinipadType(type);
        this.shearedTimer = compound.m_128451_("ShearedTimer");
        this.setSheared(this.shearedTimer > 0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("ShearedTimer", this.shearedTimer);
        compound.m_128359_("MinipadType", this.getMinipadType().getId().toString());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MinipadFloatGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MinipadPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new MinipadTryFindWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MinipadRandomStrollGoal(this, 1.0, 60, 240));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_() && --this.shearedTimer == 0) {
            this.setSheared(false);
        }
        if (!this.m_9236_().m_5776_()) {
            long time = this.m_9236_().m_46468_();
            this.setGlowing(time >= 13000L && time <= 23000L);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.floatMinipad();
        SimpleParticleType particle = this.getMinipadType().getParticle();
        if (particle != null && this.isGlowing() && !this.getSheared()) {
            if (this.f_19796_.m_188500_() < 0.1) {
                this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + (this.f_19796_.m_188500_() * 0.5 - 0.25), this.m_20186_() + 0.8 + (this.f_19796_.m_188500_() * 0.1 - 0.05), this.m_20189_() + (this.f_19796_.m_188500_() * 0.5 - 0.25), this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            }
            if (this.f_19796_.m_188500_() < 0.07) {
                this.m_9236_().m_7106_((ParticleOptions)particle, this.m_20185_() + (this.f_19796_.m_188500_() * 24.0 - 12.0), this.m_20186_() + this.f_19796_.m_188500_() * 7.5, this.m_20189_() + (this.f_19796_.m_188500_() * 24.0 - 12.0), this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag tag) {
        switch (this.f_19796_.m_188503_(3)) {
            default: {
                this.setMinipadType(CNBMinipadTypes.PINK);
                break;
            }
            case 1: {
                this.setMinipadType(CNBMinipadTypes.LIGHT_PINK);
                break;
            }
            case 2: {
                this.setMinipadType(CNBMinipadTypes.YELLOW);
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    public static boolean checkMinipadSpawnRules(EntityType<MinipadEntity> animal, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return true;
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_(0.2, 0.0, 0.2), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            int i = this.m_9236_().m_46469_().m_46215_(GameRules.f_46149_);
            if (i > 0 && list.size() > i - 1 && this.f_19796_.m_188503_(4) == 0) {
                int j = 0;
                for (Entity entity : list) {
                    if (entity.m_20159_()) continue;
                    ++j;
                }
                if (j > i - 1) {
                    this.m_6469_(this.m_269291_().m_269354_(), 6.0f);
                }
            }
            for (Entity entity : list) {
                this.m_7324_(entity);
            }
        }
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13131_);
    }

    private void floatMinipad() {
        if (this.m_20069_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13131_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.1, 0.0));
            }
        }
    }

    public boolean m_6063_() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return null;
    }

    public boolean getSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.shearedTimer = sheared ? 18000 : 0;
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public void setGlowing(boolean isGlowing) {
        this.f_19804_.m_135381_(GLOWING, (Object)isGlowing);
    }

    public boolean isGlowing() {
        return (Boolean)this.f_19804_.m_135370_(GLOWING);
    }

    public void setMinipadType(MinipadType minipadType) {
        this.f_19804_.m_135381_(TYPE, (Object)minipadType.getId().toString());
    }

    public MinipadType getMinipadType() {
        return MinipadType.getById((String)this.f_19804_.m_135370_(TYPE));
    }

    public double m_20204_() {
        return 0.45;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return !this.getSheared();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_146852_(GameEvent.f_157781_, (Entity)player);
        if (!world.f_46443_) {
            this.setSheared(true);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (this.m_9236_().m_46468_() > 13000L) {
                items.add(new ItemStack((ItemLike)this.getMinipadType().getGlowShearItem()));
            } else {
                items.add(new ItemStack((ItemLike)this.getMinipadType().getShearItem()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean shouldLookAround() {
        return !this.m_9236_().m_6425_(this.m_20183_()).m_205070_(FluidTags.f_13131_);
    }

    public int m_213860_() {
        return 2 + this.m_9236_().f_46441_.m_188503_(3);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (!this.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            this.m_5496_((SoundEvent)CNBSoundEvents.MINIPAD_STEP.get(), this.m_6121_() * 0.3f, this.m_6100_());
        }
    }

    protected SoundEvent m_5501_() {
        return (SoundEvent)CNBSoundEvents.MINIPAD_SWIM.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CNBSoundEvents.MINIPAD_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)CNBSoundEvents.MINIPAD_HURT.get();
    }

    private PlayState animationPredicate(AnimationState<MinipadEntity> event) {
        if (!(!this.m_20069_() || this.f_267362_.m_267731_() > -0.15f && this.f_267362_.m_267731_() < 0.15f)) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("minipad_swim"));
            return PlayState.CONTINUE;
        }
        if (this.m_20069_()) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("minipad_float"));
            return PlayState.CONTINUE;
        }
        if (!(this.f_267362_.m_267731_() > -0.15f) || !(this.f_267362_.m_267731_() < 0.15f)) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay("minipad_walk"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::animationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object animatable) {
        return (float)this.f_19797_ + Minecraft.m_91087_().m_91296_();
    }
}

