/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts;

import com.cgessinger.creaturesandbeasts.capabilities.CinderSwordCapability;
import com.cgessinger.creaturesandbeasts.client.CNBClient;
import com.cgessinger.creaturesandbeasts.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.config.library.Config;
import com.cgessinger.creaturesandbeasts.events.CNBEvents;
import com.cgessinger.creaturesandbeasts.init.CNBBiomeModifiers;
import com.cgessinger.creaturesandbeasts.init.CNBBlocks;
import com.cgessinger.creaturesandbeasts.init.CNBContainerTypes;
import com.cgessinger.creaturesandbeasts.init.CNBCreativeTabs;
import com.cgessinger.creaturesandbeasts.init.CNBEntityTypes;
import com.cgessinger.creaturesandbeasts.init.CNBItems;
import com.cgessinger.creaturesandbeasts.init.CNBLilytadTypes;
import com.cgessinger.creaturesandbeasts.init.CNBLizardTypes;
import com.cgessinger.creaturesandbeasts.init.CNBLootModifiers;
import com.cgessinger.creaturesandbeasts.init.CNBMinipadTypes;
import com.cgessinger.creaturesandbeasts.init.CNBPaintingTypes;
import com.cgessinger.creaturesandbeasts.init.CNBParticleTypes;
import com.cgessinger.creaturesandbeasts.init.CNBSoundEvents;
import com.cgessinger.creaturesandbeasts.init.CNBSporelingTypes;
import com.cgessinger.creaturesandbeasts.world.gen.ModEntitySpawns;
import com.electronwill.nightconfig.core.io.ParsingException;
import java.io.IOException;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cnb")
public class CreaturesAndBeasts {
    public static final String MOD_ID = "cnb";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CreativeModeTab TAB = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.cnb_tab")).m_257737_(() -> new ItemStack((ItemLike)CNBItems.GREBE_SPAWN_EGG.get())).m_257501_((params, output) -> output.m_246326_((ItemLike)CNBItems.GREBE_SPAWN_EGG.get())).m_257652_();

    public CreaturesAndBeasts() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::registerCapabilities);
        CNBParticleTypes.PARTICLE_TYPES.register(eventBus);
        CNBBlocks.BLOCKS.register(eventBus);
        CNBItems.ITEMS.register(eventBus);
        CNBContainerTypes.CONTAINER_TYPES.register(eventBus);
        CNBPaintingTypes.PAINTINGS.register(eventBus);
        CNBSoundEvents.SOUND_EVENTS.register(eventBus);
        CNBEntityTypes.ENTITY_TYPES.register(eventBus);
        CNBLootModifiers.LOOT_MODIFIERS.register(eventBus);
        CNBBiomeModifiers.BIOME_MODIFIERS.register(eventBus);
        CNBSporelingTypes.registerAll();
        CNBLizardTypes.registerAll();
        CNBLilytadTypes.registerAll();
        CNBMinipadTypes.registerAll();
        CNBCreativeTabs.CREATIVE_TABS.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)new CNBEvents());
        try {
            CNBConfig.CONFIG = Config.builder(FMLPaths.CONFIGDIR.get().resolve("creaturesandbeasts-common.toml")).loadClass(CNBConfig.class).build();
        }
        catch (ParsingException | IOException | IllegalArgumentException | IllegalStateException e) {
            throw new RuntimeException("Failed to load Creatures and Beasts config" + (e instanceof ParsingException ? ", try fixing/deleting your config file" : ""), e);
        }
        CNBConfig.CONFIG.onReload(stage -> {
            if (stage == Config.ReloadStage.PRE) {
                LOGGER.debug("Reloading Creatures and Beasts config");
            }
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModEntitySpawns.entitySpawnPlacementRegistry();
        FlowerPotBlock flowerPot = (FlowerPotBlock)Blocks.f_50276_;
        flowerPot.addPlant(CNBBlocks.PINK_WATERLILY_BLOCK.getId(), CNBBlocks.POTTED_PINK_WATERLILY);
        flowerPot.addPlant(CNBBlocks.LIGHT_PINK_WATERLILY_BLOCK.getId(), CNBBlocks.POTTED_LIGHT_PINK_WATERLILY);
        flowerPot.addPlant(CNBBlocks.YELLOW_WATERLILY_BLOCK.getId(), CNBBlocks.POTTED_YELLOW_WATERLILY);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CNBClient::init);
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)CNBItems.CACTEM_SPEAR.get()), (ResourceLocation)new ResourceLocation("throwing"), (item, resourceLocation, entity, itemPropertyFunction) -> entity != null && entity.m_6117_() && entity.m_21211_() == item ? 1.0f : 0.0f));
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        CinderSwordCapability.register(event);
    }
}

