/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.network.packet.clientbound;

import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.events.ClientNpcEntityDialogueEvent;
import com.p1nero.dialog_lib.network.packet.BasePacket;
import com.p1nero.dialog_lib.network.packet.clientbound.ClientBoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public record NPCEntityDialoguePacket(int id, CompoundTag data) implements BasePacket
{
    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.id());
        buf.m_130079_(this.data());
    }

    public static NPCEntityDialoguePacket decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        CompoundTag tag = buf.m_130260_();
        return new NPCEntityDialoguePacket(id, tag);
    }

    @Override
    public void execute(Player playerEntity) {
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91073_ != null) {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.id());
            if (entity == null) {
                return;
            }
            ClientNpcEntityDialogueEvent event = new ClientNpcEntityDialogueEvent(entity, Minecraft.m_91087_().f_91074_, this.data);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (entity instanceof IEntityNpc) {
                    IEntityNpc npc = (IEntityNpc)entity;
                    npc.setConversingPlayer(playerEntity);
                    npc.openDialogueScreen(this.data());
                }
                ClientBoundHandler.openEntityDialogScreen(entity, this.data);
            }
        }
    }
}

